select * from (
  select
    isnull(sum(f_oughtamount),0) f_oughtamount,
    isnull(sum(f_oughtfee),0) f_oughtfee,
    isnull(sum(f_gas1),0) f_gas1,
    isnull(sum(f_gas2),0) f_gas2,
    isnull(sum(f_gas3),0) f_gas3,
    isnull(sum(f_gas4),0) f_gas4,
    isnull(sum(f_money1),0) f_money1,
    isnull(sum(f_money2),0) f_money2,
    isnull(sum(f_money3),0) f_money3,
    isnull(sum(f_money4),0) f_money4,
    {groupname}
   from(
  select
    f_user_type,      --用户类型
    f_gasproperties,	--用气性质
    f_orgstr,					--营业网点
    f_filialeids,			--分公司
    f_filiale,
      f_outlets,
      convert(varchar(4),f_hand_date,23)+'年' year,
      convert(varchar(7),f_hand_date,23) month,
      cast(Datename(week,f_hand_date) as varchar)+'周'  week,
      convert(varchar(50),f_hand_date,23) day,
    f_oughtamount,
    f_oughtfee,
    c.*
  from t_handplan h left join (
    select
      f_hand_id,
      sum(f_price1) f_price1,
      sum(f_price2) f_price2,
      sum(f_price3) f_price3,
      sum(f_price4) f_price4,
      sum(f_gas1) f_gas1,
      sum(f_gas2) f_gas2,
      sum(f_gas3) f_gas3,
      sum(f_gas4) f_gas4,
      sum(f_money1) f_money1,
      sum(f_money2) f_money2,
      sum(f_money3) f_money3,
      sum(f_money4) f_money4
    from (
      select
       f_hand_id,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_price else 0 end f_price1,
       case when f_price_name='阶梯2' then f_price else 0 end f_price2,
       case when f_price_name='阶梯3' then f_price else 0 end f_price3,
       case when f_price_name='阶梯4' then f_price else 0 end f_price4,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_gas else 0 end f_gas1,
       case when f_price_name='阶梯2' then f_gas else 0 end f_gas2,
       case when f_price_name='阶梯3' then f_gas else 0 end f_gas3,
       case when f_price_name='阶梯4' then f_gas else 0 end f_gas4,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_money else 0 end f_money1,
       case when f_price_name='阶梯2' then f_money else 0 end f_money2,
       case when f_price_name='阶梯3' then f_money else 0 end f_money3,
       case when f_price_name='阶梯4' then f_money else 0 end f_money4
      from t_chargeprice
    ) hc group by f_hand_id
  ) c on h.id = c.f_hand_id
  where 1=1 and {condition}
  ) s
  group by {groupname}
) t
order by {groupname}