select * from (
	select
		f_userinfo_code,   --客户编号
		u.f_user_name,		--客户名称
		u.f_user_phone,		--客户电话
		ua.f_address,		--客户地址
		uf.f_user_type,		--客户类型
		uf.f_gasproperties,	--用气性质
		uf.f_meternumber,	--表号
		gb.f_meter_brand,	--气表品牌
		uf.f_meter_classify,--气表类型
		uf.f_table_state,
		u.f_user_state,

		u.f_userinfo_id,
		uf.f_user_id,
		uf.f_userfiles_id,
		uf.f_meter_base,	--气表底数
		uf.f_balance_amount,	--表上余额
		u.f_balance,		--账户余额
		s.f_pregas,			--预购气量
		s.f_preamount,		--预购金额
		s.f_collection,		--实交金额
		isnull(h.f_oughtamount,0)+isnull(ch.f_real_amount,0) f_oughtamount, --用气量
		isnull(h.f_oughtfee,0)+isnull(ch.f_real_fee,0) f_oughtfee,	--用气金额
		uf.f_orgid,
		uf.f_depid,
		uf.f_operatorid
	from t_userinfo u
		left join t_userfiles uf on u.f_userinfo_id = uf.f_userinfo_id
		left join t_user_address ua on u.f_userinfo_id=ua.f_userinfo_id
		left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
		left join (
			select
				f_userfiles_id,
				sum(f_pregas) f_pregas,
				sum(f_preamount) f_preamount,
				sum(f_collection) f_collection
			from t_sellinggas where f_state='有效'
			and f_operate_date>='{startDate}' and f_operate_date<='{endDate}'
			group by f_userfiles_id
		) s on s.f_userfiles_id = uf.f_userfiles_id
		left join (
			select
				f_user_id,
				sum(f_real_amount) f_real_amount,
				sum(f_real_fee) f_real_fee
			from t_cardhand where f_meter_state='已抄表'
			and f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
			group by f_user_id
		) ch on uf.f_user_id=ch.f_user_id
		left join (
			select
				f_userfiles_id,
				sum(f_oughtamount) f_oughtamount,
				sum(f_oughtfee) f_oughtfee
			from t_handplan
			where f_meter_state='已抄表' and f_hand_state='有效'
			and f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
			group by f_userfiles_id
		) h on uf.f_userfiles_id=h.f_userfiles_id
) u where {condition}
order by u.f_userinfo_code desc