package com.aote.rs;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


import com.aote.logic.LogicServer;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.json.JSONObject;
import java.util.Date;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.aote.rs.NewBuySubService;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;


/*
* 设置定时任务，查询功效差，并存到数据库中
* 方便前台查询
* */
//@Singleton
//@Component
public class BuySubTiTask {
	@Autowired
	public  SessionFactory sessionFactory;
	@Autowired
	//LogicServer logicse;
	NewBuySubService service = new NewBuySubService();
    //服务的地址
	private String ccurl;
	//logic的名字
	private String logic;

	public  BuySubTiTask(){
		super();
	}

    public void saveBuysubNum() throws ParseException {
		SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
		Date dBefore = new Date();
		Calendar calendar = Calendar.getInstance(); //得到日历

		Date startDate = new Date();//当前时间
		Date endDate = new Date();
		calendar.setTime(startDate);//把当前时间赋给日历
		calendar.add(Calendar.MONTH, -3);  //设置为前3月
		dBefore = calendar.getTime();
		String startDateStr = dateformat.format(dBefore);//前三个月
        //测试9-20到12-20的值
        //Date startDateSt = dateformat.parse("2018-07-20");
        //String startDateStr = dateformat.format(startDateSt);

		//供销差的值开始时间为三个月前的时间，结束时间为当前时间
		Double dou =  service.getFixedNum(1, dateformat.parse(startDateStr), dateformat.parse(dateformat.format(endDate)));//计算
        //测试自定义供销值的时间
        //Double dou =  service.getFixedNum(1, dateformat.parse("2018-01-20"), dateformat.parse("2018-12-20"));//计算

		String buysubStr = dou+"";
		String endDateStr = dateformat.format(endDate);
		//测试9-20到12-20的值
        //Date endDateSt = dateformat.parse("2018-12-20");
        //String endDateStr = dateformat.format(endDateSt);

		JSONObject jsonObjSon = new JSONObject();
		jsonObjSon.put("buysub",buysubStr);
		jsonObjSon.put("startDate",startDateStr);
		jsonObjSon.put("endDate",endDateStr)	;
		//System.out.println("查看对象的值"+jsonObjSon.toString());
		try {
			runlogic(jsonObjSon);
		}catch (Exception e){
			e.printStackTrace();
		}

	}
	/***
     * 启一个post请求
	 *	params 传入的对象
	 */
	private String runlogic(JSONObject params) throws Exception {
		String path= ccurl + "rs/logic/" + logic;
		String body = "{\"data\":" + params + "}";
		// POSTMethod
		System.out.println(path);
		HttpPost postMethod =new HttpPost(path);
		StringEntity se = new StringEntity(body, "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果不成功
		if (code != 200) {
			throw new RuntimeException("返回值错误：" + code);
		} else
			return EntityUtils.toString(response.getEntity(), "UTF8");
	}

    public String getCcurl() {
        return ccurl;
    }

    public void setCcurl(String ccurl) {
        this.ccurl = ccurl;
    }

    public String getLogic() {
        return logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }
}

