SELECT * from(
	SELECT
		f_meternumber,											--表钢号
		f_userinfo_code,										--用户编号
		f_user_name,											--用户姓名
		f_user_type,											--用户类型
		f_gasproperties,										--用气性质
		f_address,												--用户地址
		f_install_date,											--安装时间
		f_orgid,												--组织机构
		MIN(f_parameter_date) mindate,	                        --最早上报时间
		MAX(f_parameter_date) maxdate,			                --最晚上报时间
		SUM(type1) type1,										--待处理数量
		SUM(type1) type2										--已处理数量
	FROM(
		SELECT
			p.f_meternumber,
			u.f_userinfo_code,
			u.f_user_name,
			f.f_user_type,
			f.f_gasproperties,
			a.f_address,
			f.f_install_date,
			p.f_parameter_date,
			u.f_orgid,
			case when p.f_parameter_state='待处理' then 1 else 0 end type1,
			case when p.f_parameter_state='-处理-' then 1 else 0 end type2
		from t_userparameter p
		INNER JOIN t_userfiles AS f ON p.f_meternumber = f.f_meternumber
		INNER JOIN t_userinfo AS u ON f.f_userinfo_id = u.f_userinfo_id
		left JOIN t_user_address a on u.f_userinfo_id  = a.f_userinfo_id
		where f_parameter_state!='处理完成' and {condition}  and f_meter_classify='物联网表'
	) s
	GROUP BY f_meternumber,f_userinfo_code,f_user_name,f_user_type,
	f_gasproperties,f_address,f_install_date,f_orgid
) s
ORDER BY f_meternumber
