select 1 f_sum_count, ss.*,u2.f_userinfo_code,u3.f_area,  --列表字段
  --下面是合计字段(除总合计，总合计条数及气量，直接累加金额)
  case when ss.f_type='发卡售气' and ss.f_state<>'撤销' then 1 else 0 end  f_count_open, --发卡人数
  case when ss.f_type='发卡售气' and ss.f_state<>'撤销' then ss.f_pregas else 0 end  f_pregas_open, --发卡气量
  case when ss.f_type='发卡售气' and ss.f_state<>'撤销' then f_collection else 0 end  f_collection_open, --发卡金额
  case when ss.f_type not in ('补卡','发卡售气','换表','补气') and ss.f_state<>'撤销' then 1 else 0 end  f_count_zg, --再够人数
  case when ss.f_type not in ('补卡','发卡售气','换表','补气') and ss.f_state<>'撤销' then ss.f_pregas else 0 end  f_pregas_zg, --再够气量
  case when ss.f_type not in ('补卡','发卡售气','换表','补气') and ss.f_state<>'撤销' then f_collection else 0 end  f_collection_zg, --再够金额
  case when ss.f_type='补卡' and ss.f_state<>'撤销' then 1 else 0 end  f_count_bk, --补卡人数
  case when ss.f_type='补卡' and ss.f_state<>'撤销' then ss.f_pregas else 0 end  f_pregas_bk, --补卡气量
  case when ss.f_type='补卡' and ss.f_state<>'撤销' then f_collection else 0 end  f_collection_bk, --补卡金额
  case when ss.f_type='换表' and ss.f_state<>'撤销' then 1 else 0 end  f_count_hb, --换表人数
  case when ss.f_type='换表' and ss.f_state<>'撤销' then ss.f_pregas else 0 end  f_pregas_hb, --换表气量
  case when ss.f_type='换表' and ss.f_state<>'撤销' then f_collection else 0 end  f_collection_hb, --换表金额
  case when ss.f_type='补气' and ss.f_state<>'撤销' then 1 else 0 end  f_count_bq, --补气人数
  case when ss.f_type='补气' and ss.f_state<>'撤销' then ss.f_pregas else 0 end  f_pregas_bq, --补气气量
  case when ss.f_type='补气' and ss.f_state<>'撤销' then f_collection else 0 end  f_collection_bq, --补气金额
  case when  ss.f_state='撤销' then 1 else 0 end  f_count_cz, --总冲正人数
  case when  ss.f_state='撤销'  then ss.f_pregas else 0 end  f_pregas_cz, --总冲正气量
  case when  ss.f_state='撤销'  then f_collection else 0 end  f_collection_cz, --总冲正金额
  case when  ss.f_type<>'补气'  then ss.f_pregas else 0 end  f_shouru_gas, --除补气外总气量
  case when  ss.f_type<>'补气'  then f_collection else 0 end  f_shouru_fee --除补气外总金额
 from (
	SELECT
	    s.id,
			s.f_userinfo_id,
			s.f_user_type,
			s.f_user_name,
			s.f_state,
			s.f_operate_date,
			isnull(f_stair1amount, 0) f_stair1amount,
			isnull(f_stair1price, 0) f_stair1price,
			isnull(f_stair2amount, 0) f_stair2amount,
			isnull(f_stair2price, 0) f_stair2price,
			isnull(f_stair3amount, 0) f_stair3amount,
			isnull(f_stair3price, 0) f_stair3price,
			s.f_pregas,
			s.f_preamount,
			s.f_collection,
			s.f_zones,
			s.f_address,
		  s.f_meter_brand,
			s.f_balance,
			s.f_curbalance,
			s.f_payment,
			s.f_operator,
			s.f_type,
			isnull(s.f_comments,'') f_comments,
			s.f_orgid,
			s.f_depid,
			s.f_operatorid
	 from
	   (
			select s.f_userinfo_id,f_user_type,s.id,f_pregas,f_preamount,f_collection,
			f_balance,f_curbalance,f_payment,f_orgid,f_depid,f_operatorid,f_zones,f_user_name,f_type,f_operator,f_comments,
			isnull(f_write_date,f_operate_date) f_operate_date,f_state,f_address,f_meter_brand
			from t_sellinggas s
			where f_state<>'无效' and isnull(f_write_card,'')<>'未写卡'
			and isnull(f_write_date,f_operate_date)>='{startDate}' and isnull(f_write_date,f_operate_date)<='{endDate}'
			and {condition}  --传组织
		) s
		LEFT JOIN (
			SELECT
				f_charge_id f_charge_id,
				SUM (CASE f_price_name WHEN '阶梯1' THEN f_gas WHEN '固定气价' THEN f_gas ELSE 0 END) f_stair1amount,
				SUM (CASE f_price_name WHEN '阶梯1' THEN f_price WHEN '固定气价' THEN f_price ELSE 0 END ) f_stair1price,
				SUM (CASE f_price_name WHEN '阶梯2' THEN f_gas ELSE 0 END) f_stair2amount,
				SUM (CASE f_price_name WHEN '阶梯2' THEN f_price ELSE 0 END) f_stair2price,
				SUM (CASE f_price_name WHEN '阶梯3' THEN f_gas ELSE 0 END) f_stair3amount,
				SUM (CASE f_price_name WHEN '阶梯3' THEN f_price ELSE 0 END) f_stair3price
			FROM
				t_chargeprice
			WHERE
				f_charge_id IS NOT NULL
			GROUP BY
				f_charge_id
	) c ON s.id = c.f_charge_id
   	UNION ALL
	SELECT
	  s.id,
	  s.f_userinfo_id,
    f_user_type,
		f_user_name,
		f_state AS f_state,
		f_operate_date AS f_operate_date,
		0 AS f_stair1amount,
		0 AS f_stair1price,
		0 AS f_stair2amount,
		0 AS f_stair2price,
		0 AS f_stair3amount,
		0 AS f_stair3price,
		0 AS f_pregas,
		f_cardfees AS f_preamount,
		f_cardfees AS f_collection,
		f_zones,
		f_address,
		f_meter_brand,
		0 f_balance,
	  0 f_curbalance,
		f_payment,
		s.f_operator,
		'补卡' AS f_type,
		isnull(f_comments,'') AS f_comments,
		s.f_orgid,
		s.f_depid,
		s.f_operatorid
	FROM
		t_fillcard s
	where  f_state<>'无效'
	 and f_operate_date>='{startDate}' and f_operate_date<='{endDate}'
	and {condition}   --传组织
    UNION ALL
	SELECT
	  s.id,
    s.f_userinfo_id,
    f_user_type,
		f_user_name,
		f_state AS f_state,
		f_changemeter_date AS f_operate_date,
		0 AS f_stair1amount,
		0 AS f_stair1price,
		0 AS f_stair2amount,
		0 AS f_stair2price,
		0 AS f_stair3amount,
		0 AS f_stair3price,
		0 AS f_pregas,
		f_changemeter_fee AS f_preamount,
		f_changemeter_fee AS f_collection,
		f_zones,
		f_address,
		f_meter_brand,
		0 f_balance,
	  0 f_curbalance,
	  f_payment,
		s.f_operator,
		'换表' AS f_type,
		isnull(f_othereason,'') AS f_comments,
		s.f_orgid,
		s.f_depid,
		s.f_operatorid
	FROM
		t_changetables s
		 where f_state<>'无效' and f_type='换新表'
	and f_operate_date>='{startDate}' and f_operate_date<='{endDate}'
	and {condition}   --传组织
		union all
	SELECT
	  s.id,
    s.f_userinfo_id,
    f_user_type,
		f_user_name,
		f_state AS f_state,
		f_operate_date AS f_operate_date,
		0 AS f_stair1amount,
		0 AS f_stair1price,
		0 AS f_stair2amount,
		0 AS f_stair2price,
		0 AS f_stair3amount,
		0 AS f_stair3price,
		f_pregas AS f_pregas,
		f_preamount AS f_preamount,
		0 AS f_collection,
		f_zones,
		f_address,
		f_meter_brand,
		0 f_balance,
	    0 f_curbalance,
		'' f_payment,
		s.f_operator,
		'补气' AS f_type,
		isnull(f_othereason,'') AS f_comments,
		s.f_orgid,
		s.f_depid,
		s.f_operatorid
	FROM
		t_fillgas s
		where f_state<>'无效'
	and f_operate_date>='{startDate}'  and f_operate_date<='{endDate}'
	and {condition}  --传组织
) ss
 left join t_userinfo u2 on ss.f_userinfo_id=u2.f_userinfo_id
 left join t_user_address u3 on u2.f_userinfo_id=u3.f_userinfo_id
 {
    operatorState != $$ :
    $where ss.f_type = '{operatorState}'$,
    $ $
 }
order by {orderitem},ss.id
