package com.aote.rs;

import com.aote.sql.SqlServer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;

@Singleton
@Component
public class GasComparison {
    /**
     * 购气量比较，最新购气量与往期购气均值比较
     */

    //比较产生符合条件的用户id
    public JSONArray dataProcess(JSONArray sqlresult, String vary1, String scale1, String startDate, String endDate) {
        int vary = Integer.parseInt(vary1);
        int scale = Integer.parseInt(scale1);
        //判断比较符号。variety=false,小于往期购气量均值的用户id，variety=true,大于
        boolean variety = false;
        if (vary == 1) {
            variety = true;
        }
        JSONArray result = new JSONArray();
        JSONArray s = new JSONArray();
        //剔除不在时间段的数据
        RemoveDataByDate(sqlresult, s, startDate, endDate);
        //遍历用户数据比较购气量
        CompareGas(sqlresult, s, result, variety, scale);
        return result;
    }

    //剔除不在时间段的数据
    public void RemoveDataByDate(JSONArray sqlresult, JSONArray s, String startDate, String endDate) {
        for (int i = 0; i < sqlresult.length(); i++) {
            JSONObject jo = (JSONObject) sqlresult.get(i);
            if (jo.get("f_operate_date").toString().compareTo(startDate) >= 0 && jo.get("f_operate_date").toString().compareTo(endDate) <= 0) {
                s.put(jo);
            }
        }
    }

    //遍历用户数据比较购气量
    public void CompareGas(JSONArray sqlresult, JSONArray s, JSONArray result, boolean variety, int scale) {
        String flag = "";
        int frequency = 0;
        double gasvalue = 0;
        double snapvalue = 0;
        for (int i = 0; i < s.length(); i++) {
            JSONObject jo = (JSONObject) sqlresult.get(i);
            //初始化参数
            if (flag.equals("")) {
                flag = jo.get("f_userinfo_id").toString();
                frequency++;
                snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
                gasvalue = gasvalue + snapvalue;
            } else {
                //用户id分类（相同用户id进行往期购气量均值与最近一次购气量比较）
                if (jo.get("f_userinfo_id").toString().equals(flag)) {
                    frequency++;
                    snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
                    gasvalue = gasvalue + snapvalue;
                    if (i == sqlresult.length() - 1) {
                        JSONObject jres = new JSONObject();
                        jres.put("f_userinfo_id", flag);
                        double v = Double.parseDouble(jo.get("f_pregas").toString());
                        gasvalue = (gasvalue - v) / (frequency - 1);
                        if (variety && (v / gasvalue) > (scale + 100) / 100) {
                            result.put(jres);
                        }
                        if (!variety && (v / gasvalue) < (scale / 100)) {
                            result.put(jres);
                        }
                    }
                } else {
                    //id变化（读取到新的id，进行新的比较）
                    JSONObject jres = new JSONObject();
                    jres.put("f_userinfo_id", flag);
                    JSONObject span = (JSONObject) sqlresult.get(i - 1);
                    double v = Double.parseDouble(span.get("f_pregas").toString());
                    gasvalue = (gasvalue - v) / (frequency - 1);
                    if (variety && (v / gasvalue) > (scale + 100) / 100) {
                        jres.put("scale", "" + String.format("%.2f", Math.abs(v / gasvalue)));
                        result.put(jres);
                    }
                    if (!variety && (v / gasvalue) < (scale / 100)) {
                        jres.put("scale", "" + String.format("%.2f", Math.abs(v / gasvalue)));
                        result.put(jres);
                    }
                    // jres.put("f_pregas", gasvalue);
                    frequency = 1;
                    snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
                    gasvalue = snapvalue;
                    flag = jo.get("f_userinfo_id").toString();
                }
            }
        }
    }
}
