select
    f_charge_type,
    case f_invoice_type when '0' then '电子发票'
                        when '1' then '纸质普票'
                        when '2' then '纸质专票'
        end f_invoice_type,
    count(case when f_total_money >= 0 then e.id end) c,
    Convert(decimal(18,2), sum(f_tax_money)) f_tax_money,
    sum(isnull(f_tax, 0)) f_tax,
    sum(f_total_money) f_total_money,
    f_tax_rate
from (select * from t_eticket e where f_bill_state='有效' and f_sign_result='业务成功！') e
         left join (
    select f_eticket_id, f_tax_rate,sum(cast(f_tax as float)) f_tax
    from t_eticketdetail
    group by f_eticket_id, f_tax_rate
) ed on ed.f_eticket_id = e.id
where f_operate_date >= '{startDate}'
and f_operate_date <= '{endDate}'
and f_orgstr like '{filialeCodeStr}%'
group by f_charge_type,f_invoice_type,f_tax_rate