SELECT
	*
FROM
	(
		SELECT
		    m3.f_userinfo_id,
			m3.f_userinfo_code,
			--客户编号
			m3.f_user_name,
			--客户名称
			m2.f_address,
			--客户地址
			m1.f_meternumber,
			--表号
			m1.f_meter_base,
			--最后表读数
			isnull(
			    m1.f_gas_date,m1.f_input_date
			) f_startuse_date,
			--启用日期
			-- 防止启用日期没值页面显示null，没有启用日期取通气日期，没用通气日期取录入日期
			isnull(
				CONVERT (
					VARCHAR (100),
					m5.initinsertdate,
					21
				),
				'开户未上报'
			) initinsertdate,
			--初次上报日期
			isnull(
				CONVERT (
					VARCHAR (100),
					m5.lastinsertdate,
					21
				),
				'开户未上报'
			) lastinsertdate,
			--最后上报日期
			CASE
		WHEN lastinsertdate IS NULL THEN
			DATEDIFF(
				dd,
				isnull(
					m1.f_gas_date,f_input_date
				),
				GETDATE()
			)
		ELSE
			DATEDIFF(
				dd,
				m5.lastinsertdate,
				GETDATE()
			)
		END SLday,
		--失联天数
		m1.f_filialeids,
		m1.f_orgstr,
		m2.f_slice_area,
		--组织ID
		m1.f_filiale,
		--组织名称
		m1.f_user_type,
		--客户类型
		m1.f_gasproperties,
		--用气性质
		m4.f_meter_brand, --气表品牌
		isnull(m6.gassum,0) gassum
	FROM
		t_userfiles m1
	LEFT JOIN t_user_address m2 ON m1.f_useraddress_id = m2.id
	LEFT JOIN t_userinfo m3 ON m1.f_userinfo_id = m3.f_userinfo_id
	LEFT JOIN t_gasbrand m4 ON m1.f_gasbrand_id = m4.id
	LEFT JOIN (
		SELECT
			f_user_id,
			MIN (f_insert_date) initinsertdate,
			--初次接收时间
			MAX (f_insert_date) lastinsertdate --最后接收时间
		FROM
			t_meteread
		GROUP BY
			f_user_id
	) m5 ON m1.f_user_id = m5.f_user_id
	left join (
	select sum(f_oughtamount) gassum,f_user_id from t_handplan
	where f_hand_date
	between  isnull('{startDate}','1900-01-01') and GETDATE()
	group by f_user_id
	)m6 on m6.f_user_id=m1.f_user_id
	WHERE
		m1.f_meter_classify = '物联网表'
	AND m1.f_table_state = '正常'
	) k
WHERE
	{condition}
ORDER BY
	f_userinfo_code
