SELECT * from(
SELECT  f_user_name,                     --用户姓名
        f_userinfo_code,                      --用户编号
        f_orgstr,                        --组织机构
        f_address,                       --用户地址
        f_meternumber,                   --表钢号
        f_user_type,                     --用户类型
        f_gasproperties,                 --用气性质
        f_gasproperties2,                --用气属性
        SUM(s) t,                        --异常总数
        SUM(type1) type1,                --拆表上报
        SUM(type2) type2,                --补抄上报
        SUM(type3) type3,                --锂电低电上报
        SUM(type4) type4,                --E7上报
        SUM(type5) type5,                --E8上报
        SUM(type6) type6,                --E16上报
        SUM(type7) type7,                --E21上报
        SUM(type8) type8,                --E23上报
        SUM(type9) type9,                --其他上报
        MIN(f_insert_date) mindate,      --首次发生时间
        MAX(f_insert_date) maxdate       --最后发生时间
FROM(
	SELECT 1 s,u.f_user_name,u.f_userinfo_code,
		case when e.f_upload_type='拆表上报' then 1 else 0 end type1,
		case when e.f_upload_type='补抄上报' then 1 else 0 end type2,
		case when e.f_upload_type='锂电低电上报' then 1 else 0 end type3,
		case when e.f_upload_type='E7上报' then 1 else 0 end type4,
		case when e.f_upload_type='E8上报' then 1 else 0 end type5,
		case when e.f_upload_type='E16上报' then 1 else 0 end type6,
		case when e.f_upload_type='E21上报' then 1 else 0 end type7,
		case when e.f_upload_type='E23上报' then 1 else 0 end type8,
		case when e.f_upload_type='其他上报' then 1 else 0 end type9,
		e.f_insert_date,u.f_orgstr,f.f_meternumber,
		f.f_user_type,f.f_gasproperties,f.f_gasproperties2,a.f_address
	FROM t_meteread e
	LEFT JOIN t_userfiles f on f.f_user_id=e.f_user_id
	LEFT JOIN t_userinfo u on u.f_userinfo_id=f.f_userinfo_id
	LEFT JOIN t_user_address a on u.f_userinfo_id  = a.f_userinfo_id
	where e.f_upload_type in('拆表上报','补抄上报','锂电低电上报','E7上报','E8上报','E16上报','E21上报','E23上报','其他上报')
	and u.f_user_state='正常' and f.f_table_state='正常'
	and e.f_insert_date >= '{startDate}' and e.f_insert_date <= '{endDate}'
    and {condition}
	GROUP BY u.f_user_name,u.f_userinfo_code,e.f_upload_type,e.f_insert_date,
	u.f_orgstr,a.f_address,f.f_meternumber,f.f_user_type,
	f.f_gasproperties,f.f_gasproperties2
) t
GROUP BY f_user_name,f_userinfo_code,f_orgstr,f_address,f_meternumber,
f_user_type,f_gasproperties,f_gasproperties2
) t

ORDER BY f_user_name