select * from (
  select
    h.*,
    hd.f_stair1amount,hd.f_stair1price,hd.f_stair1fee,
    hd.f_stair2amount,hd.f_stair2price,hd.f_stair2fee,
    hd.f_stair3amount,hd.f_stair3price,hd.f_stair3fee
  from t_handplan h
  left join (
      select f_hand_id f_hand_id,
             sum(case f_price_name when '阶梯1' then f_gas  when '固定气价' then f_gas else 0 end) f_stair1amount,
             max(case f_price_name when '阶梯1' then f_price when '固定气价' then f_price else 0 end) f_stair1price,
             sum(case f_price_name when '阶梯1' then f_money when '固定气价' then f_money else 0 end) f_stair1fee,
             sum(case f_price_name when '阶梯2' then f_gas else 0 end) f_stair2amount,
             max(case f_price_name when '阶梯2' then f_price else 0 end) f_stair2price,
             sum(case f_price_name when '阶梯2' then f_money else 0 end) f_stair2fee,
             sum(case f_price_name when '阶梯3' then f_gas else 0 end) f_stair3amount,
             max(case f_price_name when '阶梯3' then f_price else 0 end) f_stair3price,
             sum(case f_price_name when '阶梯3' then f_money else 0 end) f_stair3fee
      from t_chargeprice c
				where f_operate_date between '{startDate} 00:00:00' and '{endDate} 23:59:59' and f_hand_id is not null
      group by f_hand_id
    ) hd on hd.f_hand_id=h.id
) t
where {condition} order by f_hand_date desc
