--用户用气情况分析
select
  {groupname},sum(f_oughtamount) f_oughtamount
from (
  select
    f_user_id,
    f_meternumber,
    f_user_name,
    f_address,
    f_user_type,
    f_gasproperties,
    f_orgstr,
    f_filialeids,
    f_balance,
    f_curbalance,
    f_hand_date,
    Datename(year,f_hand_date) year,
    Datename(month,f_hand_date) month,
    Datename(week,f_hand_date) week,
    Datename(day,f_hand_date) day,
    f_last_tablebase,
    f_tablebase,
    f_oughtamount,
    f_oughtfee,
    c.*,
    case when c.f_gas1+c.f_gas2+c.f_gas3+c.f_gas4!= f_oughtamount then '气量异常' else '正常' end f_gas_state,
    case when c.f_money1+c.f_money2+c.f_money3+c.f_money4!= f_oughtfee then '金额异常' else '正常' end f_money_state
  from t_handplan h left join (
    select
      f_hand_id,
      sum(f_price1) f_price1,
      sum(f_price2) f_price2,
      sum(f_price3) f_price3,
      sum(f_price4) f_price4,
      sum(f_gas1) f_gas1,
      sum(f_gas2) f_gas2,
      sum(f_gas3) f_gas3,
      sum(f_gas4) f_gas4,
      sum(f_money1) f_money1,
      sum(f_money2) f_money2,
      sum(f_money3) f_money3,
      sum(f_money4) f_money4
    from (
      select
       f_hand_id,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_price else 0 end f_price1,
       case when f_price_name='阶梯2' then f_price else 0 end f_price2,
       case when f_price_name='阶梯3' then f_price else 0 end f_price3,
       case when f_price_name='阶梯4' then f_price else 0 end f_price4,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_gas else 0 end f_gas1,
       case when f_price_name='阶梯2' then f_gas else 0 end f_gas2,
       case when f_price_name='阶梯3' then f_gas else 0 end f_gas3,
       case when f_price_name='阶梯4' then f_gas else 0 end f_gas4,
       case when f_price_name='固定气价' or f_price_name='阶梯1' then f_money else 0 end f_money1,
       case when f_price_name='阶梯2' then f_money else 0 end f_money2,
       case when f_price_name='阶梯3' then f_money else 0 end f_money3,
       case when f_price_name='阶梯4' then f_money else 0 end f_money4
      from t_chargeprice
    ) hc group by f_hand_id
  ) c on h.id = c.f_hand_id
  where {condition}
) s
group by {groupname}
