SELECT
	*
FROM
	(
	SELECT
		f.id,
		f.f_user_id,
		f.f_userinfo_id,
		f.f_user_name,
		f.f_card_id,
		f.f_fillgas,
		f.f_fillgas_fee,
		f.f_add_gas,
		f.f_lastremain_fillgas,
		f.f_theremain_fillgas,
		f.f_balance,
		f.f_curbalance,
		f.f_curtotal_gas,
		f.f_curtotal_fee,
		f.f_reason,
		f.f_othereason,
		f.f_fillgas_type,
		f.f_operator,
		f.f_fillgas_date,
		f.f_fillgas_state,
		f.f_filiale,
		f.f_outlets,
		f.f_orgstr,
		f.f_filialeids,
		f.f_sendsuccess,
		u.f_user_phone,
		u.f_idnumber,
		u.f_user_type,
		u.f_address+ ISNULL( u.f_address_detail, '' ) address,
		u.f_userinfo_code,
		m.f_gasbrand_id,
		m.f_table_state,
		b.f_meter_brand,
		isnull(
			f.f_meternumber,
			isnull((
				SELECT TOP
					1 f_meternumber
				FROM
					t_changemeter
				WHERE
					f_user_id = f.f_user_id
					AND f_changemeter_date <= f.f_fillgas_date
				ORDER BY
					f_changemeter_date
					),
				m.f_meternumber
			)) f_meternumber
		FROM
		t_fillgas f
		LEFT JOIN t_userinfo u ON f.f_userinfo_id = u.f_userinfo_id
		LEFT JOIN t_userfiles m ON f.f_user_id = m.f_user_id
		LEFT JOIN t_gasbrand b ON m.f_gasbrand_id = b.id
	) fillgas
WHERE
  {condition}  and f_fillgas_state != '无效'
ORDER BY
	f_fillgas_date DESC
