SELECT SUM
	( f_my_amount ) f_my_amount, --民用气量
	SUM ( f_fmy_amount ) f_fmy_amount,--非民用气量
	SUM ( f_oughtfee ) f_oughtfee,--总金额
	SUM ( f_oughtamount ) f_oughtamount,--总用气
	SUM ( f_my_fee ) f_my_fee,--民用金额
	SUM ( f_fmy_fee ) f_fmy_fee,--非民用金额
	COUNT ( num ) f_report_num, --上报户数
	SUBSTRING(f_filiale,len(f_filiale)-CHARINDEX('.',REVERSE(f_filiale))+2,len(f_filiale)) filiale
	{groupname}
FROM
	(
	SELECT SUM
	( CASE f_user_type WHEN '民用' THEN f_oughtamount ELSE 0 END ) f_my_amount,
	SUM ( CASE f_user_type WHEN '非民用' THEN f_oughtamount ELSE 0 END ) f_fmy_amount,
	COUNT ( f_user_id ) num,
	SUM ( CASE f_user_type WHEN '民用' THEN f_oughtfee ELSE 0 END ) f_my_fee,
	SUM ( CASE f_user_type WHEN '非民用' THEN f_oughtfee ELSE 0 END ) f_fmy_fee,
	SUM ( f_oughtamount ) f_oughtamount,
	f_filiale,
	SUM ( f_oughtfee ) f_oughtfee
{groupname}
FROM
	(
	SELECT
		u.f_user_type,--用户类型
		uf.f_filiale,--组织机构
		h.f_user_id,
		h.year,
		h.month,
		h.day,
		h.f_oughtamount,
		h.f_oughtfee
	FROM
		(
		SELECT
			f_user_id,
			CONVERT ( VARCHAR ( 4 ), f_hand_date, 23 ) + '年' YEAR,
			CONVERT ( VARCHAR ( 7 ), f_hand_date, 23 ) MONTH,
			CONVERT ( VARCHAR ( 50 ), f_hand_date, 23 ) DAY,
			f_oughtamount,
			f_oughtfee
		FROM
			t_handplan
		WHERE
			f_hand_date >= '{startDate}'
			AND f_hand_date <= '{endDate}'
			AND f_hand_state = '有效'
		) h
		LEFT JOIN t_userfiles uf ON h.f_user_id= uf.f_user_id
		LEFT JOIN t_userinfo u ON uf.f_userinfo_id = u.f_userinfo_id
	WHERE
		uf.f_meter_classify= '物联网表'
		AND {condition}
	) s
GROUP BY
	f_filiale
	{groupname},
	s.f_user_id
) t
GROUP BY
f_filiale
{groupname}
ORDER BY
f_filiale
{groupname}





