//package com.aote.rs;
//
//import org.hibernate.SQLQuery;
//import org.hibernate.ScrollableResults;
//import org.hibernate.Session;
//import org.hibernate.SessionFactory;
//import org.json.JSONObject;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//
//import javax.inject.Singleton;
//import javax.jws.WebService;
//import javax.ws.rs.Path;
//import javax.xml.crypto.Data;
//
//import java.math.BigDecimal;
//import java.math.RoundingMode;
//import java.time.DateTimeException;
//import java.util.Date;
//
///**
// * 供销差计算服务
// */
//@Path("BuySub")
//@Singleton
//@Component
//public class BuySubService {
//    @Autowired
//    public SessionFactory sessionFactory;
//
//    // 购气记录查询游标
//    private Session buySession;
//    private ScrollableResults buyResultset;
//
//    // 当前购气时间段
//    BuySegment segment = new BuySegment();
//
//    // 计算矫正比例时，总购买量及总抄表量
//    BigDecimal gasSum = new BigDecimal(0);
//    BigDecimal handSum = new BigDecimal(0);
//
//    /**
//     * 计算某个时间段的总购气量
//     */
//    public BigDecimal getAllGas(Date start, Date end) {
//        BigDecimal result = new BigDecimal(0);
//
//        // 对于每一条购气记录
//        Session session = sessionFactory.openSession();
//        String sql = "select * from (\n" +
//                "\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n" +
//                "\t from t_sellinggas\n" +
//                "\tgroup BY f_user_id,f_delivery_date\n" +
//                ") t_gas\n" +
//                "ORDER BY f_user_id, f_delivery_date";
//        SQLQuery query = session.createSQLQuery(sql);
//        ScrollableResults rs = query.scroll();
//
//        // 当前执行到的表
//        String c_userId = "";
//        // 当前表累计购气量
//        BigDecimal c_sumNum = null;
//        // 当前表开始购买时间
//        Date c_start = null;
//
//        // 当前购气量
//        BigDecimal c_num = null;
//        // 当前购气时间
//        Date c_date = null;
//
//        while(rs.next()) {
//            Object[] obj = rs.get();
//            String userId = obj[0].toString(); // 表编号
//            Date doDate = (Date)obj[1]; // 购气时间
//            BigDecimal num = (BigDecimal)obj[2]; // 购气量
//
//            // 如果表号发生了变化，说明是另外一块表的抄表数据
//            if (!userId.equals(c_userId)) {
//                // 如果上一块表还存在没有计算的购气量，对剩余部分进行计算
//                if (!c_userId.equals("") && c_date.compareTo(end) == -1) {
//                    // 如果用户有往期累购气量，按平均气量计算
//                    if (c_sumNum != null) {
//                        BigDecimal gas = this.getRemainGas(c_start, c_sumNum, c_date, end);
//                        result = result.add(gas);
//                    } else {
//                        // 剩余部分，按固定值计算
//                        BigDecimal gas = this.getRemainGas(c_date, end, new BigDecimal(2));
//                        result = result.add(gas);
//                    }
//                }
//                // 设置新表初始数据
//                c_sumNum = null;
//                c_start = doDate;
//            } else {
//                // 如果在给定范围，添加交集部分购气量
//                if (doDate.compareTo(start) >= 0 && c_date.compareTo(end) <= 0) {
//                    BigDecimal gas = this.getBuyGas(start, end, c_date, doDate, c_num);
//                    // 结果添加上次购气量
//                    result = result.add(gas);
//                }
//                // 用户累计购气量，添加上次购气量
//                if (c_sumNum == null) {
//                    c_sumNum = num;
//                } else {
//                    c_sumNum = c_sumNum.add(c_num);
//                }
//            }
//            // 记录当前指数，时间
//            c_userId = userId;
//            c_num = num;
//            c_date = doDate;
//        }
//
//        session.close();
//        return result;
//    }
//
//    /**
//     * 按固定值计算剩余时间购气量
//     * @param segEnd
//     * @param end
//     * @return
//     */
//    private BigDecimal getRemainGas(Date segEnd, Date end, BigDecimal val) {
//        // 剩余天数
//        BigDecimal days = new BigDecimal(this.getSubDays(segEnd, end));
//        // 结果
//        BigDecimal result = val.multiply(days);
//        return result;
//    }
//
//    /**
//     * 计算剩余时间段气量
//     * @param start 用户开始购气时间
//     * @param sumGas 所有时间段总购气量
//     * @param segEnd 时间段结束时间
//     * @param end 计算气量的结束时间
//     * @return
//     */
//    private BigDecimal getRemainGas(Date start, BigDecimal sumGas, Date segEnd, Date end) {
//        // 用户以往日平均气量
//        BigDecimal days = new BigDecimal(this.getSubDays(start, segEnd));
//        BigDecimal aver = sumGas.divide(days, 2);
//        // 剩余天数
//        days = new BigDecimal(this.getSubDays(segEnd, end));
//        // 结果
//        BigDecimal result = aver.multiply(days);
//        return result;
//    }
//
//    public String getStrFixenNum(){
//        System.out.println("测试logic");
//        String str = this.getFixedNum().toString();
//        //String str = "abc";
//        return str;
//    }
//     /**
//     * 计算购买气量的修正系数的过程
//     */
//    public BigDecimal getFixedNum() {
//        this.createBuyResultset();
//        this.getInnerFiexdNum();
//        this.closeBuySession();
//
//
//        // 返回比例
//        if(!this.handSum.equals(BigDecimal.ZERO))
//        {
//        	BigDecimal result = this.gasSum.divide(this.handSum, 4);
//        	return result;
//        }
//        return new BigDecimal(1);
//    }
//
//    /**
//     * 计算购买气量的修正系数
//     * @return
//     */
//    public void getInnerFiexdNum() {
//        // 对于每一条抄表数据
//        Session session = sessionFactory.openSession();
//        // 根据用户及抄表时间排序，取得本次抄表底数
//        String sql = "select f_user_id, f_hand_date, f_tablebase\n" +
//                " from t_handplan\n" +
//                "ORDER BY f_user_id, f_hand_date";
//        SQLQuery query = session.createSQLQuery(sql);
//        ScrollableResults rs = query.scroll();
//
//        // 当前执行到的表
//        String c_userId = "";
//        // 当前抄表指数
//        BigDecimal c_num = null;
//        // 当前时间
//        Date c_date = null;
//
//        while(rs.next()) {
//            Object[] obj = rs.get();
//            String userId = obj[0].toString(); // 表编号
//            Date doDate = (Date)obj[1]; // 抄表时间
//            BigDecimal num = (BigDecimal)obj[2]; // 表底数
//
//            // 如果表号发生了变化，说明是另外一块表的抄表数据
//            if (!userId.equals(c_userId)) {
//                c_userId = userId;
//            } else {
//                // 抄表气量
//                BigDecimal hand = num.subtract(c_num);
//                // 计算本次抄表阶段的总购气及总抄表
//                this.addBuyGas(c_userId, c_date, doDate, hand);
//            }
//            // 记录当前指数，时间
//            c_num = num;
//            c_date = doDate;
//        }
//
//        session.close();
//    }
//
//    /**
//     * 根据抄表记录的周期，给总购买量及总抄表量加值
//     * @param start
//     * @param end
//     * @return
//     */
//    private void addBuyGas(String userId, Date start, Date end, BigDecimal hand) {
//        // 让时间段进入抄表区间
//        while(this.segment != null && (
//                // 比当前用户小或者
//                this.segment.userId.compareTo(userId) < 0 || (
//                // 是当前用户，但是在抄表区间左边
//                this.segment.userId.equals(userId) && this.segment.end.compareTo(start) == -1))) {
//            this.segment = this.getSegment();
//        }
//
//        // 当在抄表区间内时，计算总购买量及总抄表量
//        while(this.segment != null
//                && this.segment.userId.compareTo(userId) == 0
//                && this.segment.start.compareTo(end) == -1) {
//            this.addBuyAndHand(userId, start, end, hand);
//            this.segment = this.getSegment();
//        }
//   }
//
//    /**
//     * 给总抄表及总购气量部分添加上购气时间段及抄表时间段的交集部分
//     * @param userId 抄表的用户id
//     * @param start 抄表开始时间
//     * @param end  抄表结束数据
//     * @param hand 抄表气量
//     */
//    public void addBuyAndHand(String userId, Date start, Date end, BigDecimal hand) {
//        // 取交集区域
//        Date left = start;
//        if (this.segment.start.compareTo(start) == 1) {
//            left = this.segment.start;
//        }
//        Date right = end;
//        if (this.segment.end.compareTo(end) == -1) {
//            right = this.segment.end;
//        }
//
//        // 交集部分天数
//        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
//        BigDecimal buyDays = new BigDecimal(this.getSubDays(this.segment.start, this.segment.end));
//        BigDecimal handDays = new BigDecimal(this.getSubDays(start, end));
//        // 交集部分购买量
//        BigDecimal buy = this.segment.gas.divide(buyDays, 2).multiply(days);
//        this.gasSum = this.gasSum.add(buy);
//        BigDecimal read = hand.divide(handDays, 2).multiply(days);
//        this.handSum = this.handSum.add(read);
//    }
//
//    /**
//     * 取得给定时间段交集部分购气量
//     * @param userId 抄表的用户id
//     * @param start 抄表开始时间
//     * @param end  抄表结束数据
//     * @param hand 抄表气量
//     */
//    public BigDecimal getBuyGas(Date start, Date end, Date segStart, Date segEnd, BigDecimal gas) {
//        // 取交集区域
//        Date left = start;
//        if (segStart.compareTo(start) == 1) {
//            left = segStart;
//        }
//        Date right = end;
//        if (segEnd.compareTo(end) == -1) {
//            right = segEnd;
//        }
//
//        // 交集部分天数
//        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
//        BigDecimal buyDays = new BigDecimal(this.getSubDays(segStart, segEnd));
//        // 交集部分购买量
//        BigDecimal buy = gas.divide(buyDays, 2).multiply(days);
//        return buy;
//    }
//
//    /**
//     * 计算两个日期之间相差天数
//     * @param start
//     * @param end
//     * @return
//     */
//    public int getSubDays(Date start, Date end) {
//        long nd = 1000 * 24 * 60 * 60;
//        long diff = end.getTime() - start.getTime();
//        // 计算差多少天
//        int day = (int)(diff / nd);
//        return day;
//    }
//
//
//    /**
//     * 获取计算购买数据的结果集
//     * @return
//     */
//    public ScrollableResults createBuyResultset() {
//        // 产生购气记录游标
//        this.buySession = sessionFactory.openSession();
//        String buySql = "select * from (\n" +
//                "\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n" +
//                "\t from t_sellinggas\n" +
//                "\tgroup BY f_user_id, f_delivery_date\n" +
//                ") t_gas\n" +
//                "ORDER BY f_user_id, f_delivery_date";
//        SQLQuery buyQuery = buySession.createSQLQuery(buySql);
//        buyResultset = buyQuery.scroll();
//        return buyResultset;
//    }
//
//    /**
//     * 关闭购气session
//     */
//    public void closeBuySession() {
//        this.buySession.close();
//    }
//
//    /**
//     * 获得一个新的购气时间段，只有一笔购气记录的，不产生购气时间段
//     * @return
//     */
//    public BuySegment getSegment() {
//        while(buyResultset.next()) {
//            Object[] obj = buyResultset.get();
//            String cUserId = obj[0].toString(); // 表编号
//            Date doDate = (Date) obj[1]; // 购气时间
//            BigDecimal buyGas = (BigDecimal) obj[2]; // 购买气量
//
//            // 如果与当前的是同一个用户，处理日期及气量
//            if (this.segment.userId.equals(cUserId)) {
//                this.segment.start = this.segment.end;
//                this.segment.end = doDate;
//                this.segment.gas = this.segment.preGas;
//                this.segment.preGas = buyGas;
//                return this.segment;
//            }
//            // 设置用户，本次无法计算时间段，继续
//            this.segment.userId = cUserId;
//            this.segment.end = doDate;
//            this.segment.preGas = buyGas;
//        }
//
//        this.segment = null;
//        return null;
//    }
//
//    /**
//     * 购气时间段
//     */
//    public class BuySegment {
//        public String userId; // 气表编号
//        public Date start; // 开始时间
//        public Date end; // 结束时间
//        public BigDecimal preGas; // 上次购买量
//        public BigDecimal gas; // 购买气量
//
//        public BuySegment() {
//            this.userId = "";
//        }
//
//        public String toString(){
//            JSONObject result = new JSONObject();
//            try {
//                result.put("userId", this.userId);
//                result.put("start", this.start);
//                result.put("end", this.end);
//                result.put("preGas", this.preGas);
//                result.put("gas", this.gas);
//            }
//             catch(Exception e){
//                    System.out.println("Wrong!");
//                }
//            return result.toString();
//        }
//
//        // 给购气时间段赋值
//        public void set(String userId, Date start, Date end, BigDecimal gas) {
//            this.userId = userId;
//            this.start = start;
//            this.end = end;
//            this.gas = gas;
//        }
//    }
//
//}
