//查询用户数
select 
	f_gasproperties_type,
	f_gasproperties,
	beforeuser,
	newadduser,
	account,
	startuser,
	stopuser,
	nowuser
from (
select
	t.f_gasproperties_type, 
	s.f_gasproperties,
	SUM(beforeuser) beforeuser,
	SUM(newadduser)  newadduser,
	SUM(account) account,
	SUM(startuser) startuser,
	SUM(stopuser) stopuser,
	SUM(nowuser) nowuser
from (
	//查询开始日期前正常的用户
		//查询开始日期前正常的用户（为了使任何时间段内查询数据不发生变化）
		//若用户建档时间为开始日期之前
			//1.当时为销户状态，则启用时间是开始日期之后，这一部分不能统计
			//2.当时为正常状态，则销户时间是开始日期之后，这一部分必须统计
		select 
			f_gasproperties,
			SUM(beforeuser) beforeuser,
			0 newadduser,
			0 account,
			0 startuser,
			0 stopuser,
			0 nowuser
		from (
			//seartDate前为正常用户（去掉当时为销户的用户）
			select 
				f_gasproperties,
				COUNT(f_userinfo_id) beforeuser
			from t_userinfo 
			where f_user_state='正常' and f_createfile_date<='{startDate}' 
				  and f_userinfo_id not in (
					select f_userinfo_id 
					from t_cancellation where f_operate_date>'{startDate}' and f_cancel_state='启用'
				  )
			group by f_gasproperties
			union all 
			//seartDate前为正常用户（加上当时为正常的用户）
			select 
				f_gasproperties,
				COUNT(f_userinfo_id) beforeuser
			from t_userinfo 
			where f_user_state='销户' and f_createfile_date<='{startDate}' 
				  and f_userinfo_id in (
					select f_userinfo_id 
					from t_cancellation where f_operate_date>'{startDate}' and f_cancel_state='销户'
				  )
			group by f_gasproperties
		) s group by f_gasproperties
	union all
	//查询时间段内新增用户数
		select 
			f_gasproperties,
			0 beforeuser,
			COUNT(f_userinfo_id) newadduser,
			0 account,
			0 startuser,
			0 stopuser,
			0 nowuser
		from t_userinfo 
		where f_user_state='正常' and f_createfile_date>='{startDate}' and f_createfile_date<='{endDate}'
		group by f_gasproperties
	union all
	////查询时间段内销户用户数
		select 
			u.f_gasproperties,
			0 beforeuser,
			0 newadduser,
			COUNT(t.id) account,
			0 startuser,
			0 stopuser,
			0 nowuser 
		from t_cancellation t
		left join t_userinfo u on t.f_userinfo_id=u.f_userinfo_id
		where  t.f_cancel_state='销户' and t.f_operate_date>='{startDate}' and t.f_operate_date<='{endDate}'
		group by u.f_gasproperties
	union all
	//查询时间段内启用的用户数
		select 
			u.f_gasproperties,
			0 beforeuser,
			0 newadduser,
			0 account,
			COUNT(t.id) startuser,
			0 stopuser,
			0 nowuser  
		from t_enable t
		left join t_userinfo u on t.f_userinfo_id=u.f_userinfo_id
		where   t.f_operate_date>='{startDate}' and t.f_operate_date<='{endDate}'
		group by u.f_gasproperties
	union all
	//查询时间段内停用的用户数
		select 
			u.f_gasproperties,
			0 beforeuser,
			0 newadduser,
			0 account,
			0 startuser,
			COUNT(t.id) stopuser,
			0 nowuser   
		from t_disable t
		left join t_userinfo u on t.f_userinfo_id=u.f_userinfo_id
		where   t.f_operate_date>='{startDate}' and t.f_operate_date<='{endDate}'
		group by u.f_gasproperties
union all
		//查询截止日期前正常的用户
		//查询截止日期前正常的用户（为了使任何时间段内查询数据不发生变化）
		//若用户建档时间为开始日期之前
			//1.当时为销户状态，则启用时间是截止日期之后，这一部分不能统计
			//2.当时为正常状态，则销户时间是截止日期之后，这一部分必须统计
		select 
			f_gasproperties,
			0 beforeuser,
			0 newadduser,
			0 account,
			0 startuser,
			0 stopuser,
			SUM(beforeuser) nowuser
		from (
			//endDate前为正常用户（去掉当时为销户的用户）
			select 
				f_gasproperties,
				COUNT(f_userinfo_id) beforeuser
			from t_userinfo 
			where f_user_state='正常' and f_createfile_date<='{endDate}' 
				  and f_userinfo_id not in (
					select f_userinfo_id 
					from t_cancellation where f_operate_date>'{endDate}' and f_cancel_state='启用'
				  )
			group by f_gasproperties
			union all 
			//endDate前为正常用户（加上当时为正常的用户）
			select 
				f_gasproperties,
				COUNT(f_userinfo_id) beforeuser
			from t_userinfo 
			where f_user_state='销户' and f_createfile_date<='{endDate}' 
				  and f_userinfo_id in (
					select f_userinfo_id 
					from t_cancellation where f_operate_date>'{endDate}' and f_cancel_state='销户'
				  )
			group by f_gasproperties
		) s group by f_gasproperties
) s left join
(select * from 
		t_stairprice where f_state='有效')
t on s.f_gasproperties=t.f_price_name
group by s.f_gasproperties,t.f_gasproperties_type

) s group by f_gasproperties_type,f_gasproperties,beforeuser,newadduser,account,startuser,stopuser,nowuser
