SELECT
	f_user_type f_gasproperties_type,
	f_gasproperties,
	SUM (newadduser) newadduser,
	SUM (ACCOUNT) ACCOUNT,
	SUM (startuser) startuser,
	SUM (nowuser) nowuser
FROM
	(
		--查询时间段内新增用户数
		SELECT
			f_user_type,
			f_gasproperties,
			0 beforeuser,
			COUNT (f_userinfo_id) newadduser,
			0 ACCOUNT,
			0 startuser,
			0 stopuser,
			0 nowuser
		FROM
			t_userinfo
		WHERE
			f_user_state = '正常'
		AND f_createfile_date >= '{startDate} 00:00:00'
		AND f_createfile_date <= '{endDate} 23:59:59'
		AND f_user_type IS NOT NULL
		AND f_gasproperties IS NOT NULL
		and { 		filialeCodeStr != $$:
        $
          f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
		GROUP BY
			f_user_type,
			f_gasproperties
		UNION ALL
			--查询时间段内销户用户数
			SELECT
				f_user_type,
				U .f_gasproperties,
				0 beforeuser,
				0 newadduser,
				COUNT (T . ID) ACCOUNT,
				0 startuser,
				0 stopuser,
				0 nowuser
			FROM
				t_cancellation T
			LEFT JOIN t_userinfo U ON T .f_userinfo_id = U .f_userinfo_id
			WHERE
				T .f_cancel_state = '销户'
			AND T .f_operate_date >= '{startDate} 00:00:00'
			AND T .f_operate_date <= '{endDate} 23:59:59'
			AND f_user_type IS NOT NULL
			AND f_gasproperties IS NOT NULL
			and { 		filialeCodeStr != $$:
        $
          f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
			GROUP BY
				f_user_type,
				U .f_gasproperties
			UNION ALL
				--查询时间段内启用的用户数
				SELECT
					f_user_type,
					U .f_gasproperties,
					0 beforeuser,
					0 newadduser,
					0 ACCOUNT,
					COUNT (T . ID) startuser,
					0 stopuser,
					0 nowuser
				FROM
					t_enable T
				LEFT JOIN t_userinfo U ON T .f_userinfo_id = U .f_userinfo_id
				WHERE
					T .f_operate_date >= '{startDate} 00:00:00'
				AND T .f_operate_date <= '{endDate} 23:59:59'
				AND f_user_type IS NOT NULL
				AND f_gasproperties IS NOT NULL
			and { 		filialeCodeStr != $$:
        $
          f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
				GROUP BY
					f_user_type,
					U .f_gasproperties
				UNION ALL
					--查询时间段内停用的用户数
					SELECT
						f_user_type,
						U .f_gasproperties,
						0 beforeuser,
						0 newadduser,
						0 ACCOUNT,
						0 startuser,
						COUNT (T . ID) stopuser,
						0 nowuser
					FROM
						t_disable T
					LEFT JOIN t_userinfo U ON T .f_userinfo_id = U .f_userinfo_id
					WHERE
						T .f_operate_date >= '{startDate} 00:00:00'
					AND T .f_operate_date <= '{endDate} 23:59:59'
					AND f_user_type IS NOT NULL
					AND f_gasproperties IS NOT NULL
								and { 		filialeCodeStr != $$:
        $
          f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
					GROUP BY
						f_user_type,
						U .f_gasproperties
	) s
GROUP BY
	f_user_type,
	f_gasproperties