/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import java.math.BigDecimal;
import java.util.Date;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="BuySub")
@Singleton
@Component
public class BuySubService {
    @Autowired
    public SessionFactory sessionFactory;
    private Session buySession;
    private ScrollableResults buyResultset;
    BuySegment segment = new BuySegment();
    BigDecimal gasSum = new BigDecimal(0);
    BigDecimal handSum = new BigDecimal(0);

    public BigDecimal getAllGas(Date start, Date end) {
        BigDecimal result = new BigDecimal(0);
        Session session = this.sessionFactory.openSession();
        String sql = "select * from (\n\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n\t from t_sellinggas\n\tgroup BY f_user_id,f_delivery_date\n) t_gas\nORDER BY f_user_id, f_delivery_date";
        SQLQuery query = session.createSQLQuery(sql);
        ScrollableResults rs = query.scroll();
        String c_userId = "";
        BigDecimal c_sumNum = null;
        Date c_start = null;
        BigDecimal c_num = null;
        Date c_date = null;
        while (rs.next()) {
            BigDecimal gas;
            Object[] obj = rs.get();
            String userId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal num = (BigDecimal)obj[2];
            if (!userId.equals(c_userId)) {
                if (!c_userId.equals("") && c_date.compareTo(end) == -1) {
                    if (c_sumNum != null) {
                        gas = this.getRemainGas(c_start, c_sumNum, c_date, end);
                        result = result.add(gas);
                    } else {
                        gas = this.getRemainGas(c_date, end, new BigDecimal(2));
                        result = result.add(gas);
                    }
                }
                c_sumNum = null;
                c_start = doDate;
            } else {
                if (doDate.compareTo(start) >= 0 && c_date.compareTo(end) <= 0) {
                    gas = this.getBuyGas(start, end, c_date, doDate, c_num);
                    result = result.add(gas);
                }
                c_sumNum = c_sumNum == null ? num : c_sumNum.add(c_num);
            }
            c_userId = userId;
            c_num = num;
            c_date = doDate;
        }
        session.close();
        return result;
    }

    private BigDecimal getRemainGas(Date segEnd, Date end, BigDecimal val) {
        BigDecimal days = new BigDecimal(this.getSubDays(segEnd, end));
        BigDecimal result = val.multiply(days);
        return result;
    }

    private BigDecimal getRemainGas(Date start, BigDecimal sumGas, Date segEnd, Date end) {
        BigDecimal days = new BigDecimal(this.getSubDays(start, segEnd));
        BigDecimal aver = sumGas.divide(days, 2);
        days = new BigDecimal(this.getSubDays(segEnd, end));
        BigDecimal result = aver.multiply(days);
        return result;
    }

    public String getStrFixenNum() {
        System.out.println("\u6d4b\u8bd5logic");
        String str = this.getFixedNum().toString();
        return str;
    }

    public BigDecimal getFixedNum() {
        this.createBuyResultset();
        this.getInnerFiexdNum();
        this.closeBuySession();
        if (!this.handSum.equals(BigDecimal.ZERO)) {
            BigDecimal result = this.gasSum.divide(this.handSum, 4);
            return result;
        }
        return new BigDecimal(1);
    }

    public void getInnerFiexdNum() {
        Session session = this.sessionFactory.openSession();
        String sql = "select f_user_id, f_hand_date, f_tablebase\n from t_handplan\nORDER BY f_user_id, f_hand_date";
        SQLQuery query = session.createSQLQuery(sql);
        ScrollableResults rs = query.scroll();
        String c_userId = "";
        BigDecimal c_num = null;
        Date c_date = null;
        while (rs.next()) {
            Object[] obj = rs.get();
            String userId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal num = (BigDecimal)obj[2];
            if (!userId.equals(c_userId)) {
                c_userId = userId;
            } else {
                BigDecimal hand = num.subtract(c_num);
                this.addBuyGas(c_userId, c_date, doDate, hand);
            }
            c_num = num;
            c_date = doDate;
        }
        session.close();
    }

    private void addBuyGas(String userId, Date start, Date end, BigDecimal hand) {
        while (this.segment != null && (this.segment.userId.compareTo(userId) < 0 || this.segment.userId.equals(userId) && this.segment.end.compareTo(start) == -1)) {
            this.segment = this.getSegment();
        }
        while (this.segment != null && this.segment.userId.compareTo(userId) == 0 && this.segment.start.compareTo(end) == -1) {
            this.addBuyAndHand(userId, start, end, hand);
            this.segment = this.getSegment();
        }
    }

    public void addBuyAndHand(String userId, Date start, Date end, BigDecimal hand) {
        Date left = start;
        if (this.segment.start.compareTo(start) == 1) {
            left = this.segment.start;
        }
        Date right = end;
        if (this.segment.end.compareTo(end) == -1) {
            right = this.segment.end;
        }
        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
        BigDecimal buyDays = new BigDecimal(this.getSubDays(this.segment.start, this.segment.end));
        BigDecimal handDays = new BigDecimal(this.getSubDays(start, end));
        BigDecimal buy = this.segment.gas.divide(buyDays, 2).multiply(days);
        this.gasSum = this.gasSum.add(buy);
        BigDecimal read = hand.divide(handDays, 2).multiply(days);
        this.handSum = this.handSum.add(read);
    }

    public BigDecimal getBuyGas(Date start, Date end, Date segStart, Date segEnd, BigDecimal gas) {
        Date left = start;
        if (segStart.compareTo(start) == 1) {
            left = segStart;
        }
        Date right = end;
        if (segEnd.compareTo(end) == -1) {
            right = segEnd;
        }
        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
        BigDecimal buyDays = new BigDecimal(this.getSubDays(segStart, segEnd));
        BigDecimal buy = gas.divide(buyDays, 2).multiply(days);
        return buy;
    }

    public int getSubDays(Date start, Date end) {
        long nd = 86400000L;
        long diff = end.getTime() - start.getTime();
        int day = (int)(diff / nd);
        return day;
    }

    public ScrollableResults createBuyResultset() {
        this.buySession = this.sessionFactory.openSession();
        String buySql = "select * from (\n\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n\t from t_sellinggas\n\tgroup BY f_user_id, f_delivery_date\n) t_gas\nORDER BY f_user_id, f_delivery_date";
        SQLQuery buyQuery = this.buySession.createSQLQuery(buySql);
        this.buyResultset = buyQuery.scroll();
        return this.buyResultset;
    }

    public void closeBuySession() {
        this.buySession.close();
    }

    public BuySegment getSegment() {
        while (this.buyResultset.next()) {
            Object[] obj = this.buyResultset.get();
            String cUserId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal buyGas = (BigDecimal)obj[2];
            if (this.segment.userId.equals(cUserId)) {
                this.segment.start = this.segment.end;
                this.segment.end = doDate;
                this.segment.gas = this.segment.preGas;
                this.segment.preGas = buyGas;
                return this.segment;
            }
            this.segment.userId = cUserId;
            this.segment.end = doDate;
            this.segment.preGas = buyGas;
        }
        this.segment = null;
        return null;
    }

    public class BuySegment {
        public String userId = "";
        public Date start;
        public Date end;
        public BigDecimal preGas;
        public BigDecimal gas;

        public String toString() {
            JSONObject result = new JSONObject();
            try {
                result.put("userId", (Object)this.userId);
                result.put("start", (Object)this.start);
                result.put("end", (Object)this.end);
                result.put("preGas", (Object)this.preGas);
                result.put("gas", (Object)this.gas);
            }
            catch (Exception e) {
                System.out.println("Wrong!");
            }
            return result.toString();
        }

        public void set(String userId, Date start, Date end, BigDecimal gas) {
            this.userId = userId;
            this.start = start;
            this.end = end;
            this.gas = gas;
        }
    }
}

