SELECT
	f_outlets,
	SUM (c) c,
	SUM (f_pregas) f_pregas,
	SUM (f_preamount) f_preamount,
	SUM (f_collection) f_collection
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
		f_outlets,
			COUNT (ID) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_pregas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_preamount), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_collection), 0) f_collection
		FROM
			t_sellinggas
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
			$to_date (
				'{startDate}',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
		$to_date (
			'{endDate}',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND f_state != '无效'
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f_outlets
	) s
GROUP BY
	f_outlets
ORDER BY
	f_outlets