SELECT
ROW_NUMBER() OVER(ORDER BY f_delivery_date desc) as idnumber,
		CASE WHEN f_gasproperties is null and f_delivery_date is null then '总计'
			 WHEN f_gasproperties is null then '小计' 
			 ELSE f_delivery_date END f_delivery_date,
		f_gasproperties,
		times,
		f_pregas,
		f_preamount,
		f_collection,
		'' AS fakeline
FROM (
		SELECT   
		LEFT((CONVERT(varchar(100), f_delivery_date, 23)),7) f_delivery_date, 
		f_gasproperties,
		COUNT(*) times,
		SUM(CAST(f_pregas AS NUMERIC(12,2))) f_pregas,
		SUM(CAST(f_preamount AS NUMERIC(12,2))) f_preamount,
		SUM(CAST(f_collection AS NUMERIC(12,2))) f_collection 	
		FROM (
			SELECT  
				f_delivery_date,f_gasproperties,f_pregas,f_preamount,f_collection
			FROM 
				t_sellinggas 
			WHERE 
				f_charge_state != '无效' and f_delivery_date >= '{startDate}' and f_delivery_date <= '{endDate}'
			
			UNION all
			
			SELECT  
				s1.f_correct_date as f_delivery_date,ISNULL(s2.f_gasproperties, 'null' ) f_gasproperties,s1.f_correct_gas as f_pregas,s1.f_correct_money as f_preamount, s1.f_correct_collection as f_collection 
			FROM 
				t_correctrecord s1
			JOIN 
				t_sellinggas s2 
			ON 
				s1.f_correct_id=s2.id
			WHERE 
				s1.f_correct_state != '无效'  and s1.f_correct_date >= '{startDate}' and s1.f_correct_date <= '{endDate}'
		) t
		GROUP BY 
			rollup( LEFT((CONVERT(varchar(100), f_delivery_date, 23)),7),(f_gasproperties))
) t
ORDER BY fakeline
	