SELECT 
		ROW_NUMBER() OVER(ORDER BY fake desc) as idnumber,
		f_slice_area,
		f_adjustable_name,
		f_residential_area,
		users,
		fake
FROM (		
      select 
            '' fake,
			case 
			when u.f_slice_area is null and u.f_residential_area  is null  and b.f_adjustable_name is null then '总计'
			when u.f_residential_area is null  and b.f_adjustable_name is null then '合计' 
			when u.f_residential_area is null then '小计'	ELSE u.f_slice_area 
			end f_slice_area,
			f_adjustable_name,
			b.id,
		    u.f_residential_area ,  
		    COUNT(*) users   from t_userinfo u left join t_adjustablebox b
on u.f_adjustable_id=b.id where u.f_user_state='正常' and {condition} 
group by  rollup(u.f_slice_area,(b.id,b.f_adjustable_name),u.f_residential_area)
) t
ORDER BY fake