select ttt.chargedate,ttt.f_filiale,
ttt.z2889,
ttt.z3234,
ttt.z0002,
ttt.z5134,
ttt.xianjin,
ttt.wechat,
ttt.alipay,ttt.pos,
ttt.dianzi,
ttt.others,
ISNULL(ttt.z2889,0)+ISNULL(ttt.z3234,0)+ISNULL(ttt.z0002,0)+ISNULL(ttt.z5134,0)+ISNULL(ttt.xianjin,0)+ISNULL(ttt.wechat,0)+ISNULL(ttt.alipay,0)+ISNULL(ttt.pos,0)+ISNULL(ttt.dianzi,0)+ISNULL(ttt.others,0) as alltotal
from
(select tt.chargedate,tt.f_filiale,
sum(case tt.f_payment when '转账2889' then CONVERT(DECIMAL(18,2),tt.total) else null end) z2889,
sum(case tt.f_payment when '转账3234' then CONVERT(DECIMAL(18,2),tt.total) else null end) z3234,
sum(case tt.f_payment when '转账0002' then CONVERT(DECIMAL(18,2),tt.total) else null end) z0002,
sum(case tt.f_payment when '转账5134' then CONVERT(DECIMAL(18,2),tt.total) else null end) z5134,
sum(case tt.f_payment when '现金' then CONVERT(DECIMAL(18,2),tt.total) else null end) xianjin,
sum(case tt.f_payment when '微信扫码'  then CONVERT(DECIMAL(18,2),tt.total) when '微信支付'  then CONVERT(DECIMAL(18,2),tt.total) else null end) wechat,
sum(case tt.f_payment when '支付宝扫码' then CONVERT(DECIMAL(18,2),tt.total) else null end) alipay,
sum(case tt.f_payment when 'POS机划卡' then CONVERT(DECIMAL(18,2),tt.total) else null end) pos,
sum(case tt.f_payment when '电子承兑' then CONVERT(DECIMAL(18,2),tt.total) else null end) dianzi,
sum(case tt.f_payment when '其他' then CONVERT(DECIMAL(18,2),tt.total) else null end) others
from
(select sum(t.summation) total,t.f_payment,t.chargedate,t.f_filiale from
(select SUM(CONVERT(DECIMAL(18,2),f_grossproceeds)) summation ,f_payment,convert(varchar(10),f_deliverydate,20) as chargedate,f_filiale from t_sellinggas
where {condition} and f_payfeevalid = '有效' and f_usertype = '非民用'
group by f_payment,f_deliverydate,f_filiale
) t
GROUP BY t.f_payment,t.chargedate,t.f_filiale) tt
GROUP by tt.f_filiale,tt.chargedate) ttt
order by ttt.f_filiale