/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import javax.inject.Singleton;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class GasComparison {
    public JSONArray dataProcess(JSONArray sqlresult, String vary1, String scale1, String startDate, String endDate) {
        int vary = Integer.parseInt(vary1);
        int scale = Integer.parseInt(scale1);
        boolean variety = false;
        if (vary == 1) {
            variety = true;
        }
        JSONArray result = new JSONArray();
        JSONArray s = new JSONArray();
        this.RemoveDataByDate(sqlresult, s, startDate, endDate);
        this.CompareGas(sqlresult, s, result, variety, scale);
        return result;
    }

    public void RemoveDataByDate(JSONArray sqlresult, JSONArray s, String startDate, String endDate) {
        for (int i = 0; i < sqlresult.length(); ++i) {
            JSONObject jo = (JSONObject)sqlresult.get(i);
            if (jo.get("f_delivery_date").toString().compareTo(startDate) < 0 || jo.get("f_delivery_date").toString().compareTo(endDate) > 0) continue;
            s.put((Object)jo);
        }
    }

    public void CompareGas(JSONArray sqlresult, JSONArray s, JSONArray result, boolean variety, int scale) {
        String flag = "";
        int frequency = 0;
        double gasvalue = 0.0;
        double snapvalue = 0.0;
        for (int i = 0; i < s.length(); ++i) {
            JSONObject jres;
            JSONObject jo = (JSONObject)sqlresult.get(i);
            if (flag.equals("")) {
                flag = jo.get("f_userinfo_id").toString();
                ++frequency;
                snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
                gasvalue += snapvalue;
                continue;
            }
            if (jo.get("f_userinfo_id").toString().equals(flag)) {
                ++frequency;
                snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
                gasvalue += snapvalue;
                if (i != sqlresult.length() - 1) continue;
                jres = new JSONObject();
                jres.put("f_userinfo_id", (Object)flag);
                double v = Double.parseDouble(jo.get("f_pregas").toString());
                gasvalue = (gasvalue - v) / (double)(frequency - 1);
                if (variety && v / gasvalue > (double)((scale + 100) / 100)) {
                    result.put((Object)jres);
                }
                if (variety || !(v / gasvalue < (double)(scale / 100))) continue;
                result.put((Object)jres);
                continue;
            }
            jres = new JSONObject();
            jres.put("f_userinfo_id", (Object)flag);
            JSONObject span = (JSONObject)sqlresult.get(i - 1);
            double v = Double.parseDouble(span.get("f_pregas").toString());
            gasvalue = (gasvalue - v) / (double)(frequency - 1);
            if (variety && v / gasvalue > (double)((scale + 100) / 100)) {
                jres.put("scale", (Object)("" + String.format("%.2f", Math.abs(v / gasvalue))));
                result.put((Object)jres);
            }
            if (!variety && v / gasvalue < (double)(scale / 100)) {
                jres.put("scale", (Object)("" + String.format("%.2f", Math.abs(v / gasvalue))));
                result.put((Object)jres);
            }
            frequency = 1;
            gasvalue = snapvalue = Double.parseDouble(jo.get("f_pregas").toString());
            flag = jo.get("f_userinfo_id").toString();
        }
    }
}

