/*
 * Decompiled with CFR 0.152.
 */
package com.af.expression;

import com.af.expression.Delegate;
import com.af.expression.Expression;
import com.af.expression.ExpressionType;
import com.af.expression.Token;
import com.af.expression.TokenType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import org.json.JSONArray;

public class Program {
    public String Source;
    private Queue<Token> _tokens = new LinkedList<Token>();
    private int pos;
    private boolean inString;
    private Stack<Boolean> inStrings = new Stack();

    public Program(String source) {
        this.Source = source.replaceAll("//[^\n]*", "");
    }

    public Delegate parse() {
        Expression result = this.CommaExp();
        return result.Compile();
    }

    private Expression CommaExp() {
        ArrayList<Expression> exps = new ArrayList<Expression>();
        Expression first = this.AssignExp();
        exps.add(first);
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && (",".equals(t.Value) || ";".equals(t.Value) || "\n".equals(t.Value))) {
            Expression r = this.AssignExp();
            exps.add(r);
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return Expression.Comma(exps, this.Source, this.pos);
    }

    private Expression AssignExp() {
        Token t = this.GetToken();
        int firstPos = t.StartPos;
        if (t.Type != TokenType.Identy) {
            this.pos = firstPos;
            this._tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        Expression objExp = Expression.Identy(t.Value, this.Source, this.pos);
        objExp = this.ObjectPath(objExp);
        if (objExp.type != ExpressionType.Property && objExp.type != ExpressionType.Identy) {
            this.pos = firstPos;
            this._tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        t = this.GetToken();
        if (t.Type != TokenType.Oper || !"=".equals(t.Value)) {
            this.pos = firstPos;
            this._tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        Expression exp = this.Exp();
        if (objExp.type == ExpressionType.Property) {
            String name = (String)objExp.value;
            objExp = objExp.children.get(0);
            return Expression.Assign(objExp, exp, name, this.Source, this.pos);
        }
        if (objExp.type == ExpressionType.Identy) {
            return Expression.Assign(null, exp, objExp.value.toString(), this.Source, this.pos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u53ea\u80fd\u7ed9\u5c5e\u6027\u6216\u8005\u53d8\u91cf\u8d4b\u503c!"));
    }

    private Expression Exp() {
        Expression v = this.Logic();
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && ":".equals(t.Value)) {
            Expression result = this.Logic();
            t = this.GetToken();
            if (t.Type == TokenType.Oper && ",".equals(t.Value)) {
                Expression sExp = this.Exp();
                return Expression.Condition(v, result, sExp, this.Source, this.pos);
            }
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u6709\u9ed8\u8ba4\u503c!"));
        }
        this._tokens.offer(t);
        return v;
    }

    private Expression Logic() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && "!".equals(t.Value)) {
            Expression exp = this.Logic();
            exp = Expression.Not(exp, this.Source, this.pos);
            return exp;
        }
        this._tokens.offer(t);
        Expression v = this.Compare();
        t = this.GetToken();
        while (t.Type == TokenType.Oper && ("&&".equals(t.Value) || "||".equals(t.Value))) {
            Expression exp = this.Logic();
            v = "&&".equals(t.Value) ? Expression.And(v, exp, this.Source, this.pos) : Expression.Or(v, exp, this.Source, this.pos);
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return v;
    }

    private Expression Compare() {
        Expression left = this.Math();
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && (">".equals(t.Value) || ">=".equals(t.Value) || "<".equals(t.Value) || "<=".equals(t.Value))) {
            Expression rExp = this.Math();
            if (">".equals(t.Value)) {
                return Expression.GreaterThan(left, rExp, this.Source, this.pos);
            }
            if (">=".equals(t.Value)) {
                return Expression.GreaterThanOrEqual(left, rExp, this.Source, this.pos);
            }
            if ("<".equals(t.Value)) {
                return Expression.LessThan(left, rExp, this.Source, this.pos);
            }
            if ("<=".equals(t.Value)) {
                return Expression.LessThanOrEqual(left, rExp, this.Source, this.pos);
            }
        } else if (t.Type == TokenType.Oper && ("==".equals(t.Value) || "!=".equals(t.Value))) {
            Expression rExp = this.Math();
            if ("==".equals(t.Value)) {
                return Expression.Equal(left, rExp, this.Source, this.pos);
            }
            if ("!=".equals(t.Value)) {
                return Expression.NotEqual(left, rExp, this.Source, this.pos);
            }
        }
        this._tokens.offer(t);
        return left;
    }

    private Expression Math() {
        Expression v = this.Mul();
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && ("+".equals(t.Value) || "-".equals(t.Value))) {
            Expression r = this.Mul();
            v = "+".equals(t.Value) ? Expression.Add(v, r, this.Source, this.pos) : Expression.Subtract(v, r, this.Source, this.pos);
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return v;
    }

    private Expression Mul() {
        Expression v = this.UnarySub();
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && ("*".equals(t.Value) || "/".equals(t.Value) || "%".equals(t.Value))) {
            Expression r = this.UnarySub();
            v = "*".equals(t.Value) ? Expression.Multiply(v, r, this.Source, this.pos) : ("/".equals(t.Value) ? Expression.Divide(v, r, this.Source, this.pos) : Expression.Modulo(v, r, this.Source, this.pos));
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return v;
    }

    private Expression UnarySub() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && "-".equals(t.Value)) {
            Expression r = this.Item();
            return Expression.Subtract(Expression.Constant(0, this.Source, this.pos), r, this.Source, this.pos);
        }
        this._tokens.offer(t);
        return this.Item();
    }

    private Expression Item() {
        StringBuilder objName = new StringBuilder();
        Expression objExp = this.ItemHead(objName);
        objExp = this.ObjectPath(objExp);
        return objExp;
    }

    private Expression ItemHead(StringBuilder name) {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && "(".equals(t.Value)) {
            Expression result = this.CommaExp();
            t = this.GetToken();
            if (t.Type != TokenType.Oper || !")".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("\u62ec\u53f7\u4e0d\u5339\u914d"));
            }
            return result;
        }
        if (t.Type == TokenType.Oper && "{".equals(t.Value)) {
            return this.Json();
        }
        if (t.Type == TokenType.Oper && "[".equals(t.Value)) {
            return this.JsonArray();
        }
        if (t.Type == TokenType.Oper && "$".equals(t.Value)) {
            Expression strExp = this.StringUnion();
            return strExp;
        }
        if (t.Type == TokenType.Int || t.Type == TokenType.Double || t.Type == TokenType.Bool) {
            return Expression.Constant(t.Value, this.Source, this.pos);
        }
        if (t.Type == TokenType.Identy) {
            String objName = (String)t.Value;
            if ("debugger".equals(objName)) {
                return Expression.Constant(objName, this.Source, this.pos);
            }
            if ("try".equals(objName)) {
                this._tokens.offer(t);
                return this.Try();
            }
            name.append(objName);
            return this.ObjectName(objName);
        }
        if (t.Type == TokenType.Null) {
            return Expression.Constant(null, this.Source, this.pos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u5355\u8bcd\u7c7b\u578b\u9519\u8bef\uff0c" + t));
    }

    private Expression Constant(String objName) {
        return null;
    }

    private Expression Try() {
        Token t = this.GetToken();
        if (t.Value != null && !"try".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("try-catch\u5fc5\u987b\u4ee5try\u5f00\u59cb"));
        }
        t = this.GetToken();
        if (t.Value != null && !"{".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("try\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
        }
        Expression tryExp = this.CommaExp();
        t = this.GetToken();
        if (t.Value != null && !"}".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("try\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
        }
        List<Expression> catches = this.Catch();
        Expression finallyExp = null;
        t = this.GetToken();
        if (t.Value != null && "finally".equals(t.Value)) {
            t = this.GetToken();
            if (!"{".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("finally\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
            }
            finallyExp = this.CommaExp();
            t = this.GetToken();
            if (!"}".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("finally\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
            }
        }
        this._tokens.offer(t);
        t = this.GetToken();
        return Expression.Try(tryExp, finallyExp, catches, this.Source, this.pos);
    }

    private List<Expression> Catch() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Expression catchExp = null;
        Token t = this.GetToken();
        while (t.Value != null && "catch".equals(t.Value)) {
            t = this.GetToken();
            if (!"(".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u53c2\u6570\u5fc5\u987b\u4ee5(\u5f00\u59cb"));
            }
            t = this.GetToken();
            String className = (String)t.Value;
            t = this.GetToken();
            String varName = (String)t.Value;
            t = this.GetToken();
            if (!")".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u53c2\u6570\u5fc5\u987b\u4ee5)\u7ed3\u675f"));
            }
            t = this.GetToken();
            if (!"{".equals(t.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
            }
            catchExp = this.CommaExp();
            result.add(Expression.Catch(className, varName, catchExp, this.Source, this.pos));
        }
        t = this.GetToken();
        if (t.Value != null && !"}".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
        }
        t = this.GetToken();
        this._tokens.offer(t);
        return result;
    }

    private Expression Json() {
        LinkedList<Expression> children = new LinkedList<Expression>();
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && "}".equals(t.Value)) {
            return Expression.Json(children, this.Source, this.pos);
        }
        this._tokens.offer(t);
        children.add(this.Attr());
        t = this.GetToken();
        while (t.Type == TokenType.Oper && ",".equals(t.Value)) {
            children.add(this.Attr());
            t = this.GetToken();
        }
        if (t.Type != TokenType.Oper || !"}".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u662f'}'"));
        }
        return Expression.Json(children, this.Source, this.pos);
    }

    private Expression JsonArray() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && "]".equals(t.Value)) {
            return Expression.Constant(new JSONArray(), this.Source, this.pos);
        }
        this._tokens.offer(t);
        List<Expression> ps = this.Params();
        t = this.GetToken();
        if (t.Type != TokenType.Oper || !"]".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u662f]" + t));
        }
        return Expression.Array(ps, this.Source, this.pos);
    }

    private Expression Attr() {
        Token name = this.GetToken();
        if (name.Type != TokenType.Identy) {
            throw new RuntimeException(this.GetExceptionMessage("JSON\u5bf9\u8c61\u5fc5\u987b\u662f\u5c5e\u6027\u540d"));
        }
        Token t = this.GetToken();
        if (t.Type != TokenType.Oper || !":".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u662f':'"));
        }
        Expression exp = this.Exp();
        return Expression.Attr(name.Value.toString(), exp, this.Source, this.pos);
    }

    private Expression StringUnion() {
        Expression exp = Expression.Constant("", this.Source, this.pos);
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && "{".equals(t.Value) || t.Type == TokenType.String) {
            if (t.Type == TokenType.String) {
                exp = Expression.Concat(exp, Expression.Constant(t.Value, this.Source, this.pos), this.Source, this.pos);
            } else {
                Expression objExp = this.Exp();
                t = this.GetToken();
                if (t.Type != TokenType.Oper || !"}".equals(t.Value)) {
                    throw new RuntimeException(this.GetExceptionMessage("\u7f3a\u5c11'}'"));
                }
                exp = Expression.Concat(exp, objExp, this.Source, this.pos);
            }
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return exp;
    }

    private Expression ObjectName(String objName) {
        return Expression.Identy(objName, this.Source, this.pos);
    }

    private Expression ObjectPath(Expression inExp) {
        Expression objExp = this.ArrayIndex(inExp);
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && ".".equals(t.Value)) {
            Token nameToken = this.GetToken();
            Token n = this.GetToken();
            if (n.Type == TokenType.Oper && "(".equals(n.Value)) {
                String name = (String)nameToken.Value;
                objExp = "each".equals(name) ? this.For(name, objExp) : this.MethodCall(name, objExp);
            } else {
                this._tokens.offer(n);
                String pi = (String)nameToken.Value;
                objExp = Expression.Property(objExp, pi, this.Source, this.pos);
                objExp = this.ArrayIndex(objExp);
            }
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return objExp;
    }

    private Expression ArrayIndex(Expression objExp) {
        Token n = this.GetToken();
        if (n.Type == TokenType.Oper && "[".equals(n.Value)) {
            Expression exp = this.Exp();
            n = this.GetToken();
            if (n.Type != TokenType.Oper || !"]".equals(n.Value)) {
                throw new RuntimeException(this.GetExceptionMessage("\u7f3a\u5c11']'"));
            }
            return Expression.ArrayIndex(objExp, exp, this.Source, this.pos);
        }
        this._tokens.offer(n);
        return objExp;
    }

    private Expression For(String name, Expression obj) {
        Expression exp = this.CommaExp();
        Token t = this.GetToken();
        if (t.Type != TokenType.Oper || !")".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("\u51fd\u6570\u8c03\u7528\u62ec\u53f7\u4e0d\u5339\u914d"));
        }
        return Expression.For(obj, exp, this.Source, this.pos);
    }

    private Expression MethodCall(String name, Expression obj) {
        Token t = this.GetToken();
        if (t.Type == TokenType.Oper && ")".equals(t.Value)) {
            ArrayList<Expression> ps = new ArrayList<Expression>();
            return Expression.Call(obj, name, ps, this.Source, this.pos);
        }
        this._tokens.offer(t);
        List<Expression> ps = this.Params();
        t = this.GetToken();
        if (t.Type != TokenType.Oper || !")".equals(t.Value)) {
            throw new RuntimeException(this.GetExceptionMessage("\u51fd\u6570\u8c03\u7528\u62ec\u53f7\u4e0d\u5339\u914d"));
        }
        return Expression.Call(obj, name, ps, this.Source, this.pos);
    }

    private List<Expression> Params() {
        ArrayList<Expression> ps = new ArrayList<Expression>();
        String name = this.paramName();
        Expression exp = this.Exp();
        this.procParam(ps, exp, name);
        Token t = this.GetToken();
        while (t.Type == TokenType.Oper && ",".equals(t.Value)) {
            name = this.paramName();
            exp = this.Exp();
            this.procParam(ps, exp, name);
            t = this.GetToken();
        }
        this._tokens.offer(t);
        return ps;
    }

    private String paramName() {
        Token t = this.GetToken();
        if (t.Type == TokenType.Identy) {
            Token t1 = this.GetToken();
            if (":".equals(t1.Value)) {
                return t.Value.toString();
            }
            this._tokens.offer(t);
            this._tokens.offer(t1);
            return "";
        }
        this._tokens.offer(t);
        return "";
    }

    private void procParam(List<Expression> ps, Expression exp, String name) {
        Delegate delegate = exp.Compile();
        if (delegate.objectNames.containsKey("data")) {
            ps.add(Expression.Constant(delegate, this.Source, this.pos));
        } else if ("".equals(name)) {
            ps.add(Expression.Param(exp, name, this.Source, this.pos));
        } else {
            ps.add(Expression.Param(exp, name, this.Source, this.pos));
        }
    }

    private String GetExceptionMessage(String msg) {
        String result = this.Source.substring(0, this.pos) + " <- " + this.Source.substring(this.pos);
        return msg + ", " + result;
    }

    public Token GetToken() {
        if (this._tokens.size() != 0) {
            return this._tokens.poll();
        }
        int sPos = this.pos;
        if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '{') {
            this.inStrings.push(this.inString);
            this.inString = false;
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.inString) {
            int startPos = this.pos;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) != '{' && this.Source.charAt(this.pos) != '$' && this.Source.charAt(this.pos) != '}') {
                ++this.pos;
            }
            if (this.pos >= this.Source.length() || this.Source.charAt(this.pos) != '{') {
                this.inString = this.inStrings.pop();
            }
            Token t = new Token(TokenType.String, this.Source.substring(startPos, this.pos), sPos);
            if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '$') {
                ++this.pos;
            }
            return t;
        }
        while (this.pos < this.Source.length() && (this.Source.charAt(this.pos) == ' ' || this.Source.charAt(this.pos) == '\n' || this.Source.charAt(this.pos) == '\t') || this.pos < this.Source.length() - 2 && this.Source.charAt(this.pos) == '/' && this.Source.charAt(this.pos + 1) == '/') {
            if (this.Source.charAt(this.pos) == ' ' || this.Source.charAt(this.pos) == '\n' || this.Source.charAt(this.pos) == '\t') {
                ++this.pos;
                continue;
            }
            this.pos += 2;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) != '\n') {
                ++this.pos;
            }
            ++this.pos;
        }
        if (this.pos == this.Source.length()) {
            return new Token(TokenType.End, null, sPos);
        }
        if (this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
            int oldPos = this.pos;
            while (this.pos < this.Source.length() && this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
                ++this.pos;
            }
            if (this.pos < this.Source.length() && this.Source.charAt(this.pos) == '.') {
                ++this.pos;
                while (this.pos < this.Source.length() && this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9') {
                    ++this.pos;
                }
                String str = this.Source.substring(oldPos, this.pos);
                return new Token(TokenType.Double, new BigDecimal(str), sPos);
            }
            String str = this.Source.substring(oldPos, this.pos);
            return new Token(TokenType.Int, Integer.parseInt(str), sPos);
        }
        if (this.Source.charAt(this.pos) >= 'a' && this.Source.charAt(this.pos) <= 'z' || this.Source.charAt(this.pos) >= 'A' && this.Source.charAt(this.pos) <= 'Z' || this.Source.charAt(this.pos) == '_') {
            int oldPos = this.pos;
            while (this.pos < this.Source.length() && (this.Source.charAt(this.pos) >= 'a' && this.Source.charAt(this.pos) <= 'z' || this.Source.charAt(this.pos) >= 'A' && this.Source.charAt(this.pos) <= 'Z' || this.Source.charAt(this.pos) >= '0' && this.Source.charAt(this.pos) <= '9' || this.Source.charAt(this.pos) == '_')) {
                ++this.pos;
            }
            String str = this.Source.substring(oldPos, this.pos);
            if ("false".equals(str) || "true".equals(str)) {
                return new Token(TokenType.Bool, Boolean.parseBoolean(str), sPos);
            }
            if ("null".equals(str)) {
                return new Token(TokenType.Null, null, sPos);
            }
            return new Token(TokenType.Identy, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '&' && this.Source.charAt(this.pos + 1) == '&' || this.Source.charAt(this.pos) == '|' && this.Source.charAt(this.pos + 1) == '|') {
            String str = this.Source.substring(this.pos, this.pos + 2);
            this.pos += 2;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '+' || this.Source.charAt(this.pos) == '-' || this.Source.charAt(this.pos) == '*' || this.Source.charAt(this.pos) == '/' || this.Source.charAt(this.pos) == '%' || this.Source.charAt(this.pos) == '>' || this.Source.charAt(this.pos) == '<' || this.Source.charAt(this.pos) == '!') {
            if (this.Source.charAt(this.pos + 1) == '=') {
                String str = this.Source.substring(this.pos, this.pos + 2);
                this.pos += 2;
                return new Token(TokenType.Oper, str, sPos);
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '=') {
            if (this.Source.charAt(this.pos + 1) == '=' || this.Source.charAt(this.pos + 1) == '>') {
                String str = this.Source.substring(this.pos, this.pos + 2);
                this.pos += 2;
                return new Token(TokenType.Oper, str, sPos);
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.Source.charAt(this.pos) == '(' || this.Source.charAt(this.pos) == ')' || this.Source.charAt(this.pos) == ',' || this.Source.charAt(this.pos) == ';' || this.Source.charAt(this.pos) == '.' || this.Source.charAt(this.pos) == ':' || this.Source.charAt(this.pos) == '@' || this.Source.charAt(this.pos) == '$' || this.Source.charAt(this.pos) == '{' || this.Source.charAt(this.pos) == '}' || this.Source.charAt(this.pos) == '[' || this.Source.charAt(this.pos) == ']') {
            if (this.Source.charAt(this.pos) == '$') {
                this.inStrings.push(this.inString);
                this.inString = true;
            }
            if (this.Source.charAt(this.pos) == '{' && this.inStrings.size() != 0) {
                this.inStrings.push(this.inString);
                this.inString = false;
            }
            if (this.Source.charAt(this.pos) == '}' && this.inStrings.size() != 0) {
                this.inString = this.inStrings.pop();
            }
            String str = this.Source.substring(this.pos, this.pos + 1);
            if (this.Source.charAt(this.pos) == '\n') {
                ++this.pos;
                return new Token(TokenType.Oper, str, sPos);
            }
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u65e0\u6548\u5355\u8bcd\uff1a" + this.Source.charAt(this.pos)));
    }
}

