/*
 * Decompiled with CFR 0.152.
 */
package com.af.expression;

import com.af.expression.Delegate;
import com.af.expression.ExpressionException;
import com.af.expression.ExpressionType;
import com.af.util.MethodSignatureMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Expression {
    public ExpressionType type;
    public Object value;
    public List<Expression> children = new ArrayList<Expression>();
    public Delegate delegate;
    private String source;
    private int pos;

    private Expression(ExpressionType type, String source, int pos) {
        this.type = type;
        this.source = source;
        this.pos = pos;
    }

    private Expression(ExpressionType type, Object value, String source, int pos) {
        this.type = type;
        this.value = value;
        this.source = source;
        this.pos = pos;
    }

    public static Expression Param(Expression exp, String value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Param, value, source, pos);
        result.children.add(exp);
        return result;
    }

    public static Expression Constant(Object value, String source, int pos) {
        return new Expression(ExpressionType.Constant, value, source, pos);
    }

    public static Expression Identy(Object value, String source, int pos) {
        return new Expression(ExpressionType.Identy, value, source, pos);
    }

    public static Expression Json(List<Expression> attrs, String source, int pos) {
        Expression result = new Expression(ExpressionType.Json, source, pos);
        result.children.addAll(attrs);
        return result;
    }

    public static Expression Comma(List<Expression> children, String source, int pos) {
        Expression result = new Expression(ExpressionType.Comma, source, pos);
        result.children.addAll(children);
        return result;
    }

    public static Expression Call(Expression objExp, String name, List<Expression> params, String source, int pos) {
        Expression result = new Expression(ExpressionType.Call, name, source, pos);
        result.children.add(objExp);
        result.children.addAll(params);
        return result;
    }

    public String toString() {
        return this.toString(0);
    }

    private Object condition() {
        Expression condExp = this.children.get(0);
        Expression isTrue = this.children.get(1);
        Expression isFalse = this.children.get(2);
        Object obj = condExp.invoke();
        boolean cond = this.getBoolean(obj);
        if (cond) {
            return isTrue.invoke();
        }
        return isFalse.invoke();
    }

    private Object loop() throws Exception {
        Expression objExp = this.children.get(0);
        JSONArray array = (JSONArray)objExp.invoke();
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            body.delegate.objectNames.put("row", array.get(i));
            body.invoke();
        }
        return array;
    }

    private Object where() throws Exception {
        JSONArray result = new JSONArray();
        Expression objExp = this.children.get(0);
        JSONArray array = null;
        Object ret = objExp.invoke();
        if (ret instanceof JSONArray) {
            array = (JSONArray)ret;
        } else if (ret instanceof List) {
            array = new JSONArray();
            List list = (List)ret;
            for (Object value : list) {
                array.put(value);
            }
        } else {
            throw new RuntimeException("where\u51fd\u6570\u53ea\u652f\u6301JSONArray, List");
        }
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            Object value;
            value = array.get(i);
            body.delegate.objectNames.put("row", value);
            if (!body.invoke().equals(true)) continue;
            result.put(value);
        }
        return result;
    }

    private Object sum() throws Exception {
        BigDecimal result = new BigDecimal(0);
        Expression objExp = this.children.get(0);
        JSONArray array = (JSONArray)objExp.invoke();
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            body.delegate.objectNames.put("row", value);
            Object decimal = body.invoke();
            result = decimal == null ? result.add(new BigDecimal(0)) : result.add(new BigDecimal(decimal.toString()));
        }
        return result;
    }

    public String toString(int level) {
        StringBuilder result = new StringBuilder(this.space(level) + "type: " + (Object)((Object)this.type) + ", value: " + (this.value != null ? this.value.toString() : "null") + "[\n");
        for (Expression child : this.children) {
            result.append(child != null ? child.toString(level + 1) : this.space(level + 1) + "null\n");
        }
        result.append(this.space(level)).append("]\n");
        return result.toString();
    }

    private Object convert(Object source) {
        if (source instanceof Double) {
            return new BigDecimal(source.toString());
        }
        if (source instanceof Byte || source instanceof Short || source instanceof Integer) {
            return new Integer(source.toString());
        }
        return source;
    }

    private Object assign() {
        Expression right = this.children.get(1);
        Object value = right.invoke();
        String name = (String)this.value;
        Expression left = this.children.get(0);
        if (left == null) {
            this.delegate.objectNames.put(name, value);
        } else {
            Object obj = left.invoke();
            if (obj instanceof JSONObject) {
                JSONObject json = (JSONObject)obj;
                json.put(name, value);
            } else {
                try {
                    Field field = obj.getClass().getField(name);
                    field.set(obj, value);
                    return value;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5c5e\u6027\u8d4b\u503c\u9519\u8bef\uff1a" + name);
                }
            }
        }
        return value;
    }

    private Object property() throws Exception {
        Expression objExp = this.children.get(0);
        Object obj = objExp.invoke();
        String name = (String)this.value;
        Object rObj = null;
        if (obj.getClass() == HashMap.class) {
            Map map = (Map)obj;
            if (!map.containsKey(name)) {
                return null;
            }
            rObj = map.get(name);
        } else if (obj instanceof JSONObject) {
            JSONObject json = (JSONObject)obj;
            if (!json.has(name)) {
                return null;
            }
            rObj = json.get(name);
        } else {
            Field field = obj.getClass().getField(name);
            if (field == null) {
                return null;
            }
            rObj = field.get(obj);
        }
        return this.convert(rObj);
    }

    private Object arrayIndex() throws Exception {
        Expression objExp = this.children.get(0);
        Expression indexExp = this.children.get(1);
        Object obj = objExp.invoke();
        int index = Integer.parseInt(indexExp.invoke().toString());
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            Object oRet = array.get(index);
            return this.convert(oRet);
        }
        if (obj.getClass().isArray()) {
            if (obj.getClass() == int[].class) {
                int[] array = (int[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == double[].class) {
                double[] array = (double[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == byte[].class) {
                byte[] array = (byte[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == boolean[].class) {
                boolean[] array = (boolean[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == long[].class) {
                long[] array = (long[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == short[].class) {
                short[] array = (short[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == float[].class) {
                float[] array = (float[])obj;
                return this.convert(Float.valueOf(array[index]));
            }
            if (obj.getClass() == char[].class) {
                char[] array = (char[])obj;
                return this.convert(Character.valueOf(array[index]));
            }
            Object[] array = (Object[])obj;
            return this.convert(array[index]);
        }
        throw new ExpressionException(this.source, this.pos);
    }

    private String space(int n) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            result.append("    ");
        }
        return result.toString();
    }

    private boolean isEqual(Throwable e, String name) {
        for (Class<?> c = e.getClass(); c != null; c = c.getSuperclass()) {
            int index;
            String s = c.getName();
            String catchName = s.substring((index = s.lastIndexOf(46)) + 1);
            if (!catchName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private Object Json() throws Exception {
        JSONObject result = new JSONObject();
        for (Expression child : this.children) {
            String name = child.value.toString();
            Object value = child.children.get(0).invoke();
            result.put(name, value);
        }
        return result;
    }

    private Object array() throws Exception {
        JSONArray result = new JSONArray();
        for (Expression child : this.children) {
            Object value = child.invoke();
            result.put(value);
        }
        return result;
    }

    private boolean getBoolean(Object obj) {
        boolean cond = false;
        cond = obj instanceof Boolean ? (Boolean)obj : obj != null;
        return cond;
    }

    private void debugger() {
    }

    public Delegate Compile() {
        return new Delegate(this);
    }

    public static Expression Try(Expression tryExp, Expression finallyExp, List<Expression> catches, String source, int pos) {
        Expression[] tryFinally = new Expression[]{tryExp, finallyExp};
        Expression result = new Expression(ExpressionType.Try, tryFinally, source, pos);
        result.children = catches;
        return result;
    }

    public static Expression Catch(String className, String varName, Expression catches, String source, int pos) {
        String[] catchParameter = new String[]{className, varName};
        Expression result = new Expression(ExpressionType.Catch, catchParameter, source, pos);
        result.children.add(catches);
        return result;
    }

    public Object invoke() {
        try {
            switch (this.type) {
                case Or: 
                case And: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    boolean l = this.getBoolean(left.invoke());
                    boolean r = this.getBoolean(right.invoke());
                    switch (this.type) {
                        case Or: {
                            return l || r;
                        }
                        case And: {
                            return l && r;
                        }
                    }
                    throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
                }
                case Not: {
                    Expression left = this.children.get(0);
                    boolean l = this.getBoolean(left.invoke());
                    return !l;
                }
                case Add: 
                case Subtract: 
                case Multiply: 
                case Divide: 
                case Modulo: {
                    return this.math();
                }
                case Concat: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    Object r = right.invoke();
                    return l.toString() + r.toString();
                }
                case Json: {
                    return this.Json();
                }
                case Array: {
                    return this.array();
                }
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    Object r = right.invoke();
                    if (l instanceof String && r instanceof String) {
                        int result = ((String)l).compareTo((String)r);
                        switch (this.type) {
                            case GreaterThan: {
                                return result > 0;
                            }
                            case GreaterThanOrEqual: {
                                return result >= 0;
                            }
                            case LessThan: {
                                return result < 0;
                            }
                            case LessThanOrEqual: {
                                return result <= 0;
                            }
                        }
                        throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
                    }
                    BigDecimal dl = new BigDecimal(l.toString());
                    BigDecimal dr = new BigDecimal(r.toString());
                    int cr = dl.compareTo(dr);
                    switch (this.type) {
                        case GreaterThan: {
                            return cr > 0;
                        }
                        case GreaterThanOrEqual: {
                            return cr >= 0;
                        }
                        case LessThan: {
                            return cr < 0;
                        }
                        case LessThanOrEqual: {
                            return cr <= 0;
                        }
                    }
                    throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
                }
                case Equal: 
                case NotEqual: {
                    Object r;
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    if (l == null) {
                        l = "null";
                    }
                    if ((r = right.invoke()) == null) {
                        r = "null";
                    }
                    boolean equals = l.toString().equals(r.toString());
                    switch (this.type) {
                        case Equal: {
                            return equals;
                        }
                        case NotEqual: {
                            return !equals;
                        }
                    }
                    throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
                }
                case Constant: {
                    if (this.value instanceof Double) {
                        return new BigDecimal(this.value.toString());
                    }
                    if (this.value != null && "debugger".equals(this.value.toString())) {
                        this.debugger();
                    }
                    return this.value;
                }
                case Identy: {
                    String name = (String)this.value;
                    if (!this.delegate.objectNames.containsKey(name)) {
                        return null;
                    }
                    return this.delegate.objectNames.get(name);
                }
                case Condition: {
                    return this.condition();
                }
                case Property: {
                    return this.property();
                }
                case ArrayIndex: {
                    return this.arrayIndex();
                }
                case Call: {
                    return this.call();
                }
                case For: {
                    return this.loop();
                }
                case Assign: {
                    return this.assign();
                }
                case Comma: {
                    Object value = 0;
                    for (Expression child : this.children) {
                        value = child.invoke();
                    }
                    return value;
                }
                case Try: {
                    return this.Try();
                }
                case Param: {
                    return this.Param();
                }
            }
            throw new RuntimeException("\u65e0\u6548\u64cd\u4f5c");
        }
        catch (ExpressionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionException(this.source, this.pos, ex);
        }
    }

    private AbstractMap.SimpleEntry<String, Object> Param() {
        return new AbstractMap.SimpleEntry<String, Object>(this.value.toString(), this.children.get(0).invoke());
    }

    public static Expression Property(Expression objExp, String name, String source, int pos) {
        Expression result = new Expression(ExpressionType.Property, name, source, pos);
        result.children.add(objExp);
        return result;
    }

    private Object math() {
        Expression left = this.children.get(0);
        Expression right = this.children.get(1);
        Object oLeft = left.invoke();
        Object oRight = right.invoke();
        if (oLeft instanceof BigDecimal || oRight instanceof BigDecimal) {
            BigDecimal l = new BigDecimal(left.invoke().toString());
            BigDecimal r = new BigDecimal(right.invoke().toString());
            switch (this.type) {
                case Add: {
                    return l.add(r);
                }
                case Subtract: {
                    return l.subtract(r);
                }
                case Multiply: {
                    return l.multiply(r);
                }
                case Divide: {
                    return l.divide(r);
                }
                case Modulo: {
                    return new BigDecimal(l.intValue() % r.intValue());
                }
            }
            throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
        }
        int l = Integer.parseInt(left.invoke().toString());
        int r = Integer.parseInt(right.invoke().toString());
        switch (this.type) {
            case Add: {
                return l + r;
            }
            case Subtract: {
                return l - r;
            }
            case Multiply: {
                return l * r;
            }
            case Divide: {
                return l / r;
            }
            case Modulo: {
                return l % r;
            }
        }
        throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
    }

    public static Expression Attr(String name, Expression value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Attr, source, pos);
        result.value = name;
        result.children.add(value);
        return result;
    }

    private Object call() throws Exception {
        String name = (String)this.value;
        if ("where".equals(name)) {
            return this.where();
        }
        if ("sum".equals(name)) {
            return this.sum();
        }
        Expression objExp = this.children.get(0);
        Object obj = objExp.invoke();
        ArrayList params = new ArrayList();
        for (int i = 1; i < this.children.size(); ++i) {
            Expression paramExp = this.children.get(i);
            AbstractMap.SimpleEntry map = (AbstractMap.SimpleEntry)paramExp.invoke();
            params.add(map.getValue());
        }
        Class<?> c = obj.getClass();
        Object[] types = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            types[i] = param == null ? null : param.getClass();
        }
        Method method = MethodSignatureMatcher.getMatchingMethod(c, name, types);
        if (method == null) {
            StringBuilder error = new StringBuilder("\u627e\u4e0d\u5230\u65b9\u6cd5:" + c.getName() + "." + name + "(");
            for (Object t : types) {
                if (t != null) {
                    error.append(t.toString()).append(",");
                    continue;
                }
                error.append("null,");
            }
            error.append(")");
            throw new RuntimeException(error.toString());
        }
        Object oCall = method.invoke(obj, params.toArray());
        return this.convert(oCall);
    }

    public static Expression Assign(Expression objExp, Expression exp, String name, String source, int pos) {
        Expression result = new Expression(ExpressionType.Assign, name, source, pos);
        result.children.add(objExp);
        result.children.add(exp);
        return result;
    }

    private Object Try() throws Exception {
        Expression[] exps = (Expression[])this.value;
        Expression tryExp = exps[0];
        try {
            Object object = tryExp.invoke();
            return object;
        }
        catch (ExpressionException ex) {
            Throwable e = ex.getCause();
            for (Expression exp : this.children) {
                String[] catchValues = (String[])exp.value;
                String typeName = catchValues[0];
                String varName = catchValues[1];
                if (!this.isEqual(e, typeName)) continue;
                List<Expression> catchExp = exp.children;
                this.delegate.objectNames.put(varName, e);
                Object object = catchExp.get(0).invoke();
                return object;
            }
            throw ex;
        }
        finally {
            Expression finallyExp = exps[1];
            if (finallyExp != null) {
                finallyExp.invoke();
            }
        }
    }

    public static Expression Array(List<Expression> params, String source, int pos) {
        Expression result = new Expression(ExpressionType.Array, source, pos);
        result.children = params;
        return result;
    }

    public static Expression Condition(Expression test, Expression ifTrue, Expression ifFalse, String source, int pos) {
        Expression result = new Expression(ExpressionType.Condition, source, pos);
        result.children.add(test);
        result.children.add(ifTrue);
        result.children.add(ifFalse);
        return result;
    }

    public static Expression Not(Expression exp, String source, int pos) {
        Expression result = new Expression(ExpressionType.Not, source, pos);
        result.children.add(exp);
        return result;
    }

    public static Expression And(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.And, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Or(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Or, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Equal(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Equal, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression NotEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.NotEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Add(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Add, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Subtract(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Subtract, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Multiply(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Multiply, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Divide(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Divide, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Modulo(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Modulo, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Concat(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Concat, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression ArrayIndex(Expression objExp, Expression indexExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.ArrayIndex, source, pos);
        result.children.add(objExp);
        result.children.add(indexExp);
        return result;
    }

    public static Expression For(Expression objExp, Expression forExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.For, source, pos);
        result.children.add(objExp);
        result.children.add(forExp);
        return result;
    }
}

