/*
 * Decompiled with CFR 0.152.
 */
package com.af.util;

import java.lang.reflect.Method;

public class MethodSignatureMatcher {
    public static boolean isCompatible(Method method, Object[] args) throws Exception {
        Class<?>[] targetTypes = method.getParameterTypes();
        if (args.length != targetTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> targetType = targetTypes[i];
            if (MethodSignatureMatcher.isCompatible((Class)args[i], targetType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompatible(Class<?> srcType, Class<?> targetType) {
        if (srcType == null || targetType == srcType) {
            return true;
        }
        if (targetType == Integer.TYPE && srcType == Integer.class || targetType == Integer.class && srcType == Integer.TYPE) {
            return true;
        }
        if (srcType.isInterface()) {
            return MethodSignatureMatcher.hasInterface(srcType, targetType);
        }
        if (targetType.isInterface()) {
            while (srcType != null) {
                Class<?>[] facets;
                for (Class<?> facet : facets = srcType.getInterfaces()) {
                    if (!MethodSignatureMatcher.hasInterface(facet, targetType)) continue;
                    return true;
                }
                srcType = srcType.getSuperclass();
            }
            return false;
        }
        return MethodSignatureMatcher.isSubclass(srcType, targetType);
    }

    private static boolean hasInterface(Class<?> srcType, Class<?> targetType) {
        if (targetType.isInterface()) {
            if (targetType == srcType) {
                return true;
            }
            int n = 0;
            Class<?>[] facets = srcType.getInterfaces();
            Class<?>[] classArray = facets;
            int n2 = classArray.length;
            if (n < n2) {
                Class<?> facet = classArray[n];
                if (facet == targetType) {
                    return true;
                }
                return MethodSignatureMatcher.hasInterface(facet, targetType);
            }
            return false;
        }
        while (targetType != null) {
            int n = 0;
            Class<?>[] facets = targetType.getInterfaces();
            Class<?>[] classArray = facets;
            int n3 = classArray.length;
            if (n < n3) {
                Class<?> facet = classArray[n];
                if (facet == srcType) {
                    return true;
                }
                return MethodSignatureMatcher.hasInterface(srcType, facet);
            }
            targetType = targetType.getSuperclass();
        }
        return false;
    }

    private static boolean isSubclass(Class<?> srcType, Class<?> targetType) {
        for (Class<?> superClass = srcType.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (superClass != targetType) continue;
            return true;
        }
        return null == targetType;
    }

    public static Method getMatchingMethod(Class<?> clazz, String methodName, Object[] args) throws Exception {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !MethodSignatureMatcher.isCompatible(method, args)) continue;
            return method;
        }
        return null;
    }

    public static void test(A a, I1 i1) {
    }

    public static void main(String[] args) {
        try {
            Method method = MethodSignatureMatcher.getMatchingMethod(MethodSignatureMatcher.class, "test", new Object[]{A.class, I1.class});
            assert (method != null);
            System.out.println(method.getName());
            method = MethodSignatureMatcher.getMatchingMethod(MethodSignatureMatcher.class, "test", new Object[]{C.class, I4.class});
            assert (method != null);
            System.out.println(method.getName());
            method = MethodSignatureMatcher.getMatchingMethod(MethodSignatureMatcher.class, "test", new Object[]{C.class, C.class});
            assert (method != null);
            System.out.println(method.getName());
            method = MethodSignatureMatcher.getMatchingMethod(MethodSignatureMatcher.class, "test", new Object[]{Object.class, C.class});
            System.out.println(method != null ? method.getName() : "null");
            method = MethodSignatureMatcher.getMatchingMethod(MethodSignatureMatcher.class, "test", new Object[]{C.class, Object.class});
            System.out.println(method != null ? method.getName() : "null");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class C
    extends B {
    }

    public class B
    extends A {
    }

    public class A
    implements I4 {
    }

    public static interface I4
    extends I3 {
    }

    public static interface I3
    extends I1,
    I2 {
    }

    public static interface I2 {
    }

    public static interface I1 {
    }
}

