/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.WebUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestParamsUtils {
    private static final List<String> apiParamNames = new ArrayList<String>();

    public static IcbcHashMap parseParams(HttpServletRequest req) throws IOException {
        String queryStr;
        String bodyStr;
        IcbcHashMap params = new IcbcHashMap();
        if (req.getMethod().equals("POST") && !StringUtils.isEmpty(bodyStr = HttpRequestParamsUtils.getRequestBodyString(req))) {
            params.putAll(HttpRequestParamsUtils.parseParams(bodyStr));
        }
        if (!StringUtils.isEmpty(queryStr = req.getQueryString())) {
            params.putAll(HttpRequestParamsUtils.parseParams(queryStr));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRequestBodyString(HttpServletRequest req) throws IOException {
        ServletInputStream inputStream = req.getInputStream();
        InputStreamReader ir = new InputStreamReader((InputStream)inputStream);
        BufferedReader br = new BufferedReader(ir);
        try {
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            inputStream.close();
            ir.close();
            br.close();
        }
    }

    public static String parseReqPath(HttpServletRequest req) {
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        contextPath = contextPath == null ? "" : contextPath;
        contextPath = contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length()) : contextPath;
        return contextPath + servletPath;
    }

    public static String getRequestStrToSign(String path, IcbcHashMap params) {
        HashMap<String, String> map = new HashMap<String, String>(params);
        map.remove("sign");
        return WebUtils.buildOrderedSignStr(path, map);
    }

    public static Map<String, String> parseParams(String paramStr) throws IOException {
        Map<String, String> orgMap = HttpRequestParamsUtils.parseRawParams(paramStr);
        String charset = orgMap.get("charset");
        charset = charset == null ? "UTF-8" : charset;
        IcbcHashMap params = new IcbcHashMap();
        for (Map.Entry<String, String> entry : orgMap.entrySet()) {
            params.put(entry.getKey(), URLDecoder.decode(entry.getValue(), charset));
        }
        return params;
    }

    public static Map<String, String> parseRawParams(String paramStr) {
        String[] pairs = paramStr.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String pair : pairs) {
            int index = pair.indexOf(61);
            String name = pair.substring(0, index);
            String value = pair.substring(index + 1);
            paramMap.put(name, value);
        }
        return paramMap;
    }

    public static boolean isApiParam(String paramName) {
        return apiParamNames.contains(paramName);
    }

    static {
        apiParamNames.add("sign");
        apiParamNames.add("app_id");
        apiParamNames.add("sign_type");
        apiParamNames.add("charset");
        apiParamNames.add("format");
        apiParamNames.add("encrypt_type");
        apiParamNames.add("timestamp");
        apiParamNames.add("msg_id");
    }
}

