/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.IcbcResponse;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.utils.HttpClientUtils;
import com.icbc.api.utils.IcbcEncrypt;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.IcbcSignature;
import com.icbc.api.utils.WebUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIcbcClient
implements IcbcClient {
    private static final Log logger = LogFactory.getLog(DefaultIcbcClient.class);
    protected String appId;
    protected String privateKey;
    protected String signType = "RSA";
    protected String charset = "UTF-8";
    protected String format = "json";
    protected String icbcPulicKey;
    protected String encryptKey;
    protected String encryptType;
    protected String ca;
    protected String password;
    protected String emSignIp;
    protected String emSignPort;
    protected String emProduct;
    private String zoneNo = null;
    private String refineInfo = null;
    private Map<String, String> headerParams = new HashMap<String, String>();

    public DefaultIcbcClient(String appId, String signType, String privateKey, String charset, String format, String icbcPulicKey, String encryptType, String encryptKey, String ca, String password) {
        this.appId = appId;
        this.signType = signType;
        this.privateKey = privateKey;
        this.charset = charset;
        this.format = format;
        this.icbcPulicKey = icbcPulicKey;
        this.encryptType = encryptType;
        this.encryptKey = encryptKey;
        this.password = password;
        this.emSignIp = null;
        this.emSignPort = null;
        this.emProduct = null;
        if (ca != null && !ca.equals("")) {
            Pattern p = Pattern.compile("\\s*|\t");
            Matcher m2 = p.matcher(ca);
            ca = m2.replaceAll("");
        }
        this.ca = ca;
    }

    public DefaultIcbcClient(String appId, String signType, String privateKey, String charset, String format, String icbcPulicKey, String encryptType, String encryptKey, String ca, String password, String emSignIp, String emSignPort, String emProduct) {
        this.appId = appId;
        this.signType = signType;
        this.privateKey = privateKey;
        this.charset = charset;
        this.format = format;
        this.icbcPulicKey = icbcPulicKey;
        this.encryptType = encryptType;
        this.encryptKey = encryptKey;
        this.password = password;
        this.emSignIp = emSignIp;
        this.emSignPort = emSignPort;
        this.emProduct = emProduct;
        if (ca != null && !ca.equals("")) {
            Pattern p = Pattern.compile("\\s*|\t");
            Matcher m2 = p.matcher(ca);
            ca = m2.replaceAll("");
        }
        this.ca = ca;
    }

    public DefaultIcbcClient(String appId, String privateKey, String icbcPulicKey) {
        this(appId, "RSA", privateKey, "UTF-8", "json", icbcPulicKey, null, null, null, null, null, null, null);
    }

    public DefaultIcbcClient(String appId, String signType, String privateKey, String icbcPulicKey) {
        this(appId, signType, privateKey, "UTF-8", "json", icbcPulicKey, null, null, null, null, null, null, null);
    }

    public DefaultIcbcClient(String appId, String privateKey, String icbcPulicKey, String ca, String password) {
        this(appId, "CA", privateKey, "UTF-8", "json", icbcPulicKey, null, null, ca, password, null, null, null);
    }

    public DefaultIcbcClient(String appId, String signType, String emSignIp, String emSignPort, String icbcPulicKey, String emProduct) {
        this(appId, "EM", null, "UTF-8", "json", icbcPulicKey, null, null, null, null, emSignIp, emSignPort, emProduct);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        return this.execute(request, msgId);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request, String msgId) throws IcbcApiException {
        return this.execute(request, msgId, "");
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> request, String msgId, String appAuthToken) throws IcbcApiException {
        IcbcHashMap params = this.prepareParams(request, msgId, appAuthToken);
        String respStr = null;
        if (request.getMethod().equals("GET")) {
            if (this.zoneNo != null) {
                this.headerParams.put("Zone-No", this.zoneNo);
            }
            if (this.refineInfo != null) {
                this.headerParams.put("Apirefined-Info", this.refineInfo);
            }
            respStr = WebUtils.doGet(request.getServiceUrl(), (Map<String, String>)params, this.charset, this.headerParams);
        } else if (request.getMethod().equals("POST")) {
            if (this.zoneNo != null) {
                this.headerParams.put("Zone-No", this.zoneNo);
            }
            if (this.refineInfo != null) {
                this.headerParams.put("Apirefined-Info", this.refineInfo);
            }
            respStr = WebUtils.doPost(request.getServiceUrl(), (Map<String, String>)params, this.charset, this.headerParams);
        } else {
            logger.error((Object)("only support GET or POST, method: " + request.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + request.getMethod());
        }
        T response = this.parse(request, respStr);
        if (response == null) {
            logger.error((Object)"response is null.");
            throw new IcbcApiException("response is null.");
        }
        return response;
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> request, WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        UUID uuid = UUID.randomUUID();
        String msgId = uuid.toString().replace("-", "");
        this.execute(request, msgId, callback);
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> request, String msgId, WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        this.execute(request, msgId, null, callback);
    }

    @Override
    public <T extends IcbcResponse> void execute(final IcbcRequest<T> request, String msgId, String appAuthToken, final WebUtils.IcbcApiFutureCallback<T> callback) throws IcbcApiException {
        IcbcHashMap params = this.prepareParams(request, msgId, appAuthToken);
        WebUtils.IcbcApiFutureCallback<String> callbackWrapper = new WebUtils.IcbcApiFutureCallback<String>(){

            @Override
            public void completed(String result) {
                try {
                    callback.completed(DefaultIcbcClient.this.parse(request, result));
                }
                catch (IcbcApiException e) {
                    callback.failed(e);
                }
            }

            @Override
            public void failed(IcbcApiException ex) {
                callback.failed(ex);
            }
        };
        if (request.getMethod().equals("GET")) {
            WebUtils.doGet(request.getServiceUrl(), (Map<String, String>)params, this.charset, callbackWrapper);
        } else if (request.getMethod().equals("POST")) {
            WebUtils.doPost(request.getServiceUrl(), (Map<String, String>)params, this.charset, callbackWrapper);
        } else {
            logger.error((Object)("only support GET or POST, method: " + request.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + request.getMethod());
        }
    }

    protected <T extends IcbcResponse> T parse(IcbcRequest<T> request, String respStr) throws IcbcApiException {
        return this.parseJsonWithIcbcSign(request, respStr);
    }

    private <T extends IcbcResponse> T parseJsonWithIcbcSign(IcbcRequest<T> request, String respStr) throws IcbcApiException {
        String respBizContentStr = null;
        String sign = null;
        try {
            int indexOfRootStart = respStr.indexOf("response_biz_content") + "response_biz_content".length() + 2;
            int indexOfRootEnd = respStr.lastIndexOf(",\"sign\":\"");
            int indexOfSignStart = indexOfRootEnd + "sign".length() + 5;
            int indexOfSignEnd = respStr.lastIndexOf("\"");
            respBizContentStr = respStr.substring(indexOfRootStart, indexOfRootEnd);
            sign = respStr.substring(indexOfSignStart, indexOfSignEnd);
        }
        catch (Exception e) {
            logger.error((Object)("response is not format json. respStr :\n" + respStr), (Throwable)e);
            throw new IcbcApiException("response is not format json. respStr :\n" + respStr, e);
        }
        boolean passed = false;
        passed = "SM2".equals(this.signType) ? IcbcSignature.verify(respBizContentStr, this.signType, this.icbcPulicKey, this.charset, sign) : IcbcSignature.verify(respBizContentStr, "RSA", this.icbcPulicKey, this.charset, sign);
        if (!passed) {
            logger.error((Object)"icbc sign verify not passed.");
            throw new IcbcApiException("icbc sign verify not passed.");
        }
        if (request.isNeedEncrypt()) {
            respBizContentStr = IcbcEncrypt.decryptContent(respBizContentStr.substring(1, respBizContentStr.length() - 1), this.encryptType, this.encryptKey, this.charset);
        }
        try {
            return (T)((IcbcResponse)JSON.parseObject(respBizContentStr, request.getResponseClass()));
        }
        catch (Exception e) {
            logger.error((Object)("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName()), (Throwable)e);
            throw new IcbcApiException("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), e);
        }
    }

    protected IcbcHashMap prepareParams(IcbcRequest<?> request, String msgId, String appAuthToken) throws IcbcApiException {
        String path;
        String bizContentStr = this.buildBizContentStr(request);
        try {
            path = new URL(request.getServiceUrl()).getPath();
        }
        catch (MalformedURLException e) {
            logger.error((Object)("url is not valid. url: " + request.getServiceUrl()), (Throwable)e);
            throw new IcbcApiException("url is not valid. url: " + request.getServiceUrl(), e);
        }
        IcbcHashMap params = new IcbcHashMap();
        Map<String, String> extraParams = request.getExtraParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        params.put("app_id", this.appId);
        params.put("sign_type", this.signType);
        params.put("charset", this.charset);
        params.put("format", this.format);
        params.put("ca", this.ca);
        params.put("app_auth_token", appAuthToken);
        params.put("msg_id", msgId);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        params.put("timestamp", df.format(new Date(timestamp)));
        if (request.isNeedEncrypt()) {
            if (!StringUtils.areNotEmpty(this.encryptType, this.encryptKey)) {
                logger.error((Object)"request need be encrypted, encrypt type and encrypt key can not be null.");
                throw new IcbcApiException("request need be encrypted, encrypt type and encrypt key can not be null.");
            }
            if (bizContentStr != null) {
                params.put("encrypt_type", this.encryptType);
                params.put("biz_content", IcbcEncrypt.encryptContent(bizContentStr, this.encryptType, this.encryptKey, this.charset));
            }
        } else {
            params.put("biz_content", bizContentStr);
        }
        String strToSign = WebUtils.buildOrderedSignStr(path, params);
        if (this.signType.equals("CA") || this.signType.equals("RSA") || this.signType.equals("RSA2") || this.signType.equals("SM2")) {
            String signedStr = IcbcSignature.sign(strToSign, this.signType, this.privateKey, this.charset, this.password);
            params.put("sign", signedStr);
        } else if (this.signType.equals("EM")) {
            try {
                String signedStr = this.getNCSSign(strToSign, this.emSignIp, this.emSignPort, this.emProduct);
                params.put("sign", signedStr);
            }
            catch (IOException e) {
                logger.error((Object)"NC\u7b7e\u540d\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef.");
                throw new IcbcApiException("sign failed. emProduct: " + this.emProduct, e);
            }
        } else {
            logger.error((Object)"NsignType is not supported.");
        }
        return params;
    }

    protected String getNCSSign(String strToSign, String SemSignIp, String emSignPort, String emProduct) throws IOException {
        String signedStr = null;
        String sCoding = "UTF-8";
        try {
            String repSignContent;
            URL aURL = new URL("http://" + SemSignIp + ":" + emSignPort);
            HttpURLConnection urlConnection = (HttpURLConnection)aURL.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            if (emProduct.equals("CFCA")) {
                urlConnection.setRequestProperty("Request-Type", "1");
            }
            urlConnection.setRequestProperty("Content-Length", String.valueOf(strToSign.getBytes(sCoding).length));
            urlConnection.setRequestProperty("Content-Type", "INFOSEC_SIGN/1.0");
            BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            out.write(strToSign.getBytes(sCoding));
            out.flush();
            out.close();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                logger.error((Object)"NC\u53d1\u9001\u5931\u8d25.");
            }
            String resM = urlConnection.getResponseMessage();
            StringBuffer repContent = new StringBuffer("");
            InputStreamReader in = new InputStreamReader(urlConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(in);
            String readLine = null;
            while ((readLine = bufferedReader.readLine()) != null) {
                repContent.append(readLine);
            }
            in.close();
            urlConnection.disconnect();
            int beginSign = 0;
            int endSign = 0;
            try {
                beginSign = repContent.indexOf("<sign>") + 6;
                endSign = repContent.indexOf("</sign>");
            }
            catch (Exception e) {
                logger.error((Object)"NC\u8fd4\u56de\u5931\u8d25.");
            }
            signedStr = repSignContent = repContent.substring(beginSign, endSign);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"NC\u901a\u4fe1\u548c\u7b7e\u540d\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef,\u6216\u8005emport\u7c7b\u578b\u4e0d\u662fCFCA\u6216\u8005NC.");
            e.printStackTrace();
        }
        return signedStr;
    }

    protected String buildBizContentStr(IcbcRequest<?> request) throws IcbcApiException {
        if (request.getBizContent() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return JSON.toJSONString(request.getBizContent());
        }
        logger.error((Object)("only support json format, current format is not supported. format: " + this.format));
        throw new IcbcApiException("only support json format, current format is not supported. format: " + this.format);
    }

    @Deprecated
    public String getZoneNo() {
        return this.zoneNo;
    }

    @Deprecated
    public void setZoneNo(String zoneNo) {
        this.zoneNo = zoneNo;
    }

    public void setProxy(String proxyIp, int proxyPort) {
        HttpClientUtils.setProxy(proxyIp, proxyPort);
    }

    public void setHttpsProxy(String proxyIp, int proxyPort) {
        HttpClientUtils.setHttpsProxy(proxyIp, proxyPort);
    }

    public void setProxy(HttpHost proxy) {
        HttpClientUtils.setProxy(proxy);
    }

    public String getRefineInfo() {
        return this.refineInfo;
    }

    public void setRefineInfo(String refineInfo) {
        this.refineInfo = refineInfo;
    }

    public void setHeaderParam(String key, String value) {
        this.headerParams.put(key, value);
    }

    public void setFovaRegion(String fovaRegion) {
        this.headerParams.put("X-Fova-Region", fovaRegion);
    }
}

