package com.bjq.plugin;


import com.alibaba.fastjson.JSON;
import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author pgz
 * @Time 2022/3/20 8:46
 * @Description 组合树形结构
 */
public class Treedata {

    public com.alibaba.fastjson.JSONArray toTree(JSONArray obj) {
        try {

            List<Menu> menuList = new ArrayList<Menu>();
            for (int i = 0; i < obj.length(); i++) {
                String areaid = obj.getJSONObject(i).get("areaid").toString();
                String parentid = obj.getJSONObject(i).get("parentid").toString();
                String areaname = obj.getJSONObject(i).get("areaname").toString();
                String orgid = obj.getJSONObject(i).get("orgid").toString();

                menuList.add(new Menu(areaid, parentid, areaname, orgid));
            }

            MenuTree menuTree = new MenuTree(menuList);
            menuList = menuTree.builTree();
            //String jsonOutput= JSON.toJSONString(menuList);

            com.alibaba.fastjson.JSONArray objects = JSON.parseArray(JSON.toJSONString(menuList));
            return objects;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
