package com.aote;

import com.af.plugins.DateTools;
import com.af.plugins.ReportTools;
import com.aote.entity.EntityServer;
import com.aote.rs.Server;
import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.*;
import javassist.NotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.ws.rs.PathParam;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Transactional
@Component
@Singleton
public class Apply {

    public static void main(String[] args) {
        System.out.println(ReportTools.toUppercase(2354.22));
    }

    public static void test() {
        Session session = SessionPool.getInstance().getSession();
        String hql="DELETE t_actorperson WHERE  actorid='R(营业厅报装)'";
        Query query = session.createQuery(hql);
        query.executeUpdate();

        Map actor = new HashMap();
        actor.put("res", "营业厅报装");
        actor.put("id", "R(营业厅报装)");

        Set persons = new HashSet();
        Map map = new HashMap<String, String>();
        map.put("userseq", "35832");
        map.put("userid", "报建测试");
        persons.add(map);

        actor.put("f_person", persons);
        if (session.get("t_actor", actor.get("id").toString()) != null) {
            session.evict(session.get("t_actor", actor.get("id").toString()));
        }
        session.saveOrUpdate("t_actor", actor);
    }

    public void test1() {
        Session session = SessionPool.getInstance().getSession();
        PersonService.Run("R(营业厅报装)", session, "报建测试" , "35832");
    }

    public int test2(String processid) {
        try {
            Session session = SessionPool.getInstance().getSession();
            ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
            ProcessDef process = procIns.getDefine();
            // 获取活动定义
            ActivityDef activity = process.getActivityByName("信息确认");
            String exp = activity.getPersonExpression();

            ActivityInstance actIns = new ActivityInstance(activity, procIns, activity.getPersonExpression(), "报建测试", "35832", null);
            exp = (String)actIns.getProcess().getExpressionValue("$" + exp);
            PersonService.Run(exp, session, "报建测试", "35832");
            System.out.println("=======================================");
            session.save(actIns);
            return actIns.getId();
        } catch (Error e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }



    @Autowired
    private EntityServer entityServer;
    public void test3 () throws Exception {
        Map t_actor = new HashMap();
        Session session = SessionPool.getInstance().getSession();
        System.out.println("============查询前====================");
        System.out.println(session.contains(t_actor));

        t_actor = (HashMap)session.get("t_actor", "R(设计部报装)");

        System.out.println("============查询后，删除前====================");
        System.out.println(session.contains(t_actor));

        if (t_actor != null) {
            session.delete(t_actor);
        }

        System.out.println("============删除后====================");
        System.out.println(session.contains(t_actor));

//        Map actor = new HashMap();
//        actor.put("id", "R(设计部报装)");
//        actor.put("res", "设计部报装");

        Set persons = new HashSet();
        String str = "{source: 'tool.getChildrenOfResName($设计部报装$)', userid: ''}";
        persons= PersonService.getPerson(persons, str);

        t_actor.put("f_person", persons);

        System.out.println("============保存前====================");
        System.out.println(session.contains(t_actor));
        session.saveOrUpdate("t_actor", t_actor);
        System.out.println("============保存后====================");
        System.out.println(session.contains(t_actor));
        System.out.println(session.get("t_actor", t_actor.get("id").toString()));
    }
}
