package com.af.plugin;


import com.af.plugins.DateTools;
import com.alibaba.fastjson.JSON;
import com.aote.entity.EntityServer;
import com.aote.plugins.ServiceNoGenerator;
import com.aote.sql.SqlServer;
import com.aote.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OldApply {

    public static void main(String[] args) {
        JSONObject obj = new JSONObject();
        obj.put("a","a");
        obj.put("b","b");
        obj.put("c","");


        System.out.println(obj.optString("d"));
    }

    @Autowired
    private ServiceNoGenerator serviceNoGenerator;

    public void createUserinfo(JSONObject apply,JSONObject user, EntityServer entity, SqlServer sql) throws Exception {

        JSONObject street = new JSONObject();
        JSONObject area = new JSONObject();
        JSONObject address = new JSONObject();
        JSONObject userinfo = new JSONObject();
        JSONObject userfile = new JSONObject();
        String sqlStr = null;
        JSONArray jsonArray = null;

        if (StringUtil.hasLength(apply.optString("f_address"))) {
            // 查询该地址是否存在档案信息
            sqlStr = "select ui.f_userinfo_id,ui.f_userinfo_code from t_user_address ua left join t_userinfo ui on ua.f_userinfo_id = ui.f_userinfo_id where ua.f_address = '" + apply.get("f_address") + "' and ui.f_user_name = '" + apply.get("f_user_name") + "' and ui.f_orgid = '" + apply.get("f_orgid") + "'";

            jsonArray = sql.query(sqlStr);

            if (jsonArray.length() > 0) {
                apply.put("f_userinfo_id", jsonArray.getJSONObject(0).get("f_userinfo_id"));
                apply.put("f_userinfo_code", jsonArray.getJSONObject(0).get("f_userinfo_code"));

                apply.put("f_sub_state", "终止");
                apply.put("f_stop_reason", "档案存在");
                apply.put("f_stop_remarks", "系统自动处理，该用户档案已经存在！！！");
                apply.put("f_stop_date", DateTools.getNow2());
                apply.put("f_stop_user", user.get("name"));
                apply.put("f_stop_user_id", user.get("id"));

                entity.partialSave("t_old_apply", apply);
                return;
            }
        } else {
            apply.put("f_address", apply.get("f_unit_address"));
        }

        sqlStr = "select * from t_street where f_street = '-' and f_orgid = '"+ apply.get("f_orgid") +"'";
        jsonArray = sql.query(sqlStr);
        street = jsonArray.getJSONObject(0);

        if (StringUtil.hasLength(apply.optString("f_unit_num")) && StringUtil.hasLength(apply.optString("f_unit_name"))) {
            sqlStr = "select * from t_area where f_area_id = '" + apply.optString("f_unit_num") + "'";
            jsonArray = sql.query(sqlStr);
            if (jsonArray.length() == 0) {
                area.put("f_area_id", apply.opt("f_unit_num"));
                area.put("f_pcd", street.opt("f_pcd"));
                area.put("f_pcd_id", street.opt("f_pcd_id"));
                area.put("f_street", street.opt("f_street"));
                area.put("f_street_id", street.opt("id"));
                area.put("f_slice_area", "市区");
                area.put("f_residential_area", apply.get("f_unit_name"));
                area.put("f_area_address", apply.get("f_unit_address"));
                area.put("f_operate_date", DateTools.getNow2());
                area.put("f_filialeid", user.get("orgid"));
                area.put("f_orgid", apply.get("f_orgid"));
                area.put("f_orgname", apply.get("f_orgname"));
                area.put("f_depid", user.get("depids"));
                area.put("f_depname", user.get("parentname"));
                area.put("f_operatorid", user.get("id"));
                area.put("f_comments", "报装旧数据导入");

                entity.partialSave("t_area", area);

                sqlStr = "select * from t_area where f_area_id = '" + apply.getString("f_unit_num") + "'";
                jsonArray = sql.query(sqlStr);
                area = jsonArray.getJSONObject(0);
            } else {
                area = jsonArray.getJSONObject(0);
            }
        }



        // 地址
        address.put("f_pcd",street.get("f_pcd"));
        address.put("f_pcd_id",street.opt("f_pcd_id"));
        address.put("f_slice_area","市区");
        address.put("f_street",street.opt("f_street"));
        address.put("f_street_id",street.opt("id"));
        address.put("f_residential_area",area.opt("f_residential_area"));
        address.put("f_residential_area_id",area.opt("id"));
        if (area == null || !StringUtil.hasLength(area.optString("f_area_id"))) {
            address.put("f_special", 1);
        }
        address.put("f_room",apply.get("f_address"));
        address.put("f_address",apply.get("f_address"));

        address.put("f_address_state", "未通气");
        address.put("f_create_date", DateTools.getNow2());
        address.put("f_create_person", user.get("name"));
        address.put("f_operator", user.get("name"));
        address.put("f_filialeid", apply.get("f_orgid"));
        address.put("f_orgid", apply.get("f_orgid"));
        address.put("f_orgname", apply.get("f_orgname"));
        address.put("f_depid", user.get("depids"));
        address.put("f_depname", user.get("parentname"));
        address.put("f_operatorid", user.get("id"));
        address.put("f_process_id", apply.getString("f_apply_num"));
        address.put("f_comments", "报装旧数据导入");
        entity.partialSave("t_user_address", address);

        if (area != null && StringUtil.hasLength(area.optString("f_area_id"))) {
            userinfo.put("f_userinfo_code",area.optString("f_area_id") + serviceNoGenerator.getNo(area.optString("f_area_id"), 4));
        } else {
            // 周口市天然气有限公司
            if ("10101".equals(user.optString("orgid"))) {
                userinfo.put("f_userinfo_code", "10010000" + serviceNoGenerator.getNo("10010000", 4));
            }
            // 鹿邑县天然气有限公司
            if ("35532".equals(user.optString("orgid"))) {
                userinfo.put("f_userinfo_code", "12010000" + serviceNoGenerator.getNo("12010000", 4));
            }
            // 项城市天然气有限公司
            if ("35520".equals(user.optString("orgid"))) {
                userinfo.put("f_userinfo_code", "11010000" + serviceNoGenerator.getNo("11010000", 4));
            }
            // 西华县天然气有限公司
            if ("35526".equals(user.optString("orgid"))) {
                userinfo.put("f_userinfo_code", "13010000" + serviceNoGenerator.getNo("13010000", 4));
            }
            // 郸城县天然气有限公司
            if ("35538".equals(user.optString("orgid"))) {
                userinfo.put("f_userinfo_code", "14010000" + serviceNoGenerator.getNo("14010000", 4));
            }
        }

        userinfo.put("f_user_name", apply.get("f_user_name"));
        userinfo.put("f_user_phone", apply.get("f_phone"));
        userinfo.put("f_credentials", "身份证");
        userinfo.put("f_idnumber", apply.get("f_idnumber"));
        userinfo.put("f_comments", "报装旧数据导入");

        userinfo.put("f_user_state", "预备");
        userinfo.put("f_createfile_person", user.get("name"));
        userinfo.put("f_createfile_date", DateTools.getNow2());
        userinfo.put("f_filialeid", apply.get("f_orgid"));
        userinfo.put("f_orgid", apply.get("f_orgid"));
        userinfo.put("f_orgname", apply.get("f_orgname"));
        userinfo.put("f_depid", user.get("depids"));
        userinfo.put("f_depname", user.get("deps"));
        userinfo.put("f_operatorid", user.get("id"));
        userinfo.put("f_operator", user.get("name"));
        userinfo.put("f_process_id", apply.get("f_apply_num"));

        // 表具信息处理
        userfile.put("f_table_state", "正常");
        userfile.put("f_useraddress_id", address.get("id"));
        userfile.put("f_user_id", serviceNoGenerator.getNo("f_user_id",0));
        userfile.put("f_filialeid", apply.get("f_orgid"));
        userfile.put("f_orgid", apply.get("f_orgid"));
        userfile.put("f_orgname", apply.get("f_orgname"));
        userfile.put("f_depid", user.get("depids"));
        userfile.put("f_depname", user.get("deps"));
        userfile.put("f_operatorid", user.get("id"));
        userfile.put("f_operator", user.get("name"));
        userfile.put("f_open_date", DateTools.getNow2());
        userfile.put("f_comments", "报装旧数据导入");

        // 用户类型
        userfile.put("f_user_type", "民用");
        if ("商业".equals(apply.getString("f_gas_nature")) || "工业".equals(apply.getString("f_gas_nature"))) {
            userfile.put("f_user_type", "非民用");
        }

        userinfo.put("userfiles", userfile);

        entity.partialSave("t_userinfo", userinfo);

        sql.run("update t_user_address set f_userinfo_id = '" + userinfo.get("f_userinfo_id") + "' where id = '" + address.get("id") + "'");

        apply.put("f_userinfo_id", userinfo.get("f_userinfo_id"));
        apply.put("f_userinfo_code", userinfo.get("f_userinfo_code"));

        entity.partialSave("t_old_apply", apply);
    }


}
