
package com.af.plugin;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.ThreadResource;
import com.aote.logic.LogicServer;
import com.aote.rs.LogicService;
import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.*;
import com.aote.workflow.plugin.WorkFlowLogicServer;
import org.springframework.scheduling.annotation.Scheduled;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.util.*;

@Component
@Transactional
public class ApplyUtils {

    public static void main(String[] args) throws Exception{
        System.out.println(DateTools.getNow("yyyy-MM-dd"));
    }

    @Autowired
    private SessionPool sessionPool;

    public Session assignedSession;

    public void test(String processid) throws Exception {
        Session session = assignedSession == null ? sessionPool.getSession() : assignedSession;
//
//        ProcessInstance procIns = (ProcessInstance) session.get(ProcessInstance.class, processid);
//        ProcessDef process = procIns.getDefine();
//        // 获取活动定义
//        ActivityDef activity = process.getActivityByName("报装申请");
//        String exp = activity.getPersonExpression();
//
//        ActivityInstance actIns = new ActivityInstance(activity, procIns, activity.getPersonExpression(), "报建测试", "35814", null);
//        exp = (String)actIns.getProcess().getExpressionValue("$" + exp);
//        PersonService.Run(exp, session, "报建测试", "35814");
        PersonService.Run("R(营业厅报装)", session, "报建测试", "35814");

//        session.save(actIns);
    }

    /**
     * 获取节点名称
     * @param name 流程配置文件名
     * @return
     */
    public static JSONArray getDefnames(String name){
        JSONArray array = new JSONArray();

        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
        List list = process.getActivities();
        list.forEach(item -> {
            ActivityDef def = (ActivityDef)item;
            JSONObject object = new JSONObject();
            object.put("label",def.getName());
            object.put("value",def.getName());
            array.put(object);
        });

        return array;
    }

    /**
     * 获取配置文件路径
     * @param fileName 文件名
     * @return
     */
    public static JSONObject getConfigs(String fileName) {
        // 从线程变量里获取登录用户目录名
        String dir = ThreadResource.ComponentDir.get();

        String path = null;
        if (dir != null) {
            path = dir + "/jsonfiles/" + fileName + ".json";
            if (ProcessDefManager.class.getClassLoader().getResourceAsStream(path) != null) {
                return JsonTools.readJsonFile(path);
            }
        }
        path = "jsonfiles/" + fileName + ".json";
        if (ProcessDefManager.class.getClassLoader().getResourceAsStream(path) != null) {
            return JsonTools.readJsonFile(path);
        }
        return null;
    }

    /**
     * 判断类型
     * @param value
     * @return
     */
    public static String  checkType(Object value ){
        if(value instanceof Double){
            return "Double";
        }else if(value instanceof String){
            return  "String";
        }else if(value instanceof Boolean){
            return  "Boolean";
        }else if(value instanceof Long){
            return  "Long";
        }else if(value instanceof Integer){
            return  "Integer";
        }else if(value instanceof Float){
            return  "Float";
        }else if(value instanceof Short){
            return  "Short";
        }else if(value instanceof JSONObject){
            return  "JSONObject";
        }else if(value == null){
            return null;
        }else {
            return null;
        }
    }

    public static String toUppercase(String number){
        double n = Double.parseDouble(number);
        String fraction[] = { "角", "分"};
        String digit[] = { "零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
        String unit[][] = { { "元", "万", "亿"}, { "", "拾", "佰", "仟"}};

        String head = n < 0 ? "负" : "";
        n = Math.abs(n);

        String s = "";
        for (int i = 0; i < fraction.length; i++) {
            s += (digit[(int) (Math.floor(n * 10 * Math.pow(10, i)) % 10)] + fraction[i]).replaceAll("(零.)+", "");
        }
        if (s.length() < 1) {
            s = "整";
        }
        int integerPart = (int) Math.floor(n);

        for (int i = 0; i < unit[0].length && integerPart > 0; i++) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0; j++) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart = integerPart / 10;
            }
            s = p.replaceAll("(零.)*零$", "").replaceAll("^$", "零") + unit[0][i] + s;
        }
        return head + s.replaceAll("(零.)*零元", "元").replaceFirst("(零.)+", "").replaceAll("(零.)+", "零").replaceAll("^整$", "零元整");
    }

    /**
     * 获取编号
     * @param number 起始数字
     * @param prefix 前置
     * @param suffix 后置
     * @param length 长度
     * @return
     */
    public static String getNumber(Integer number, String prefix, String suffix, Integer length) {
        return prefix + mendNumber(number, 0, length) + suffix;
    }

    /**
     * 补齐数字
     * @param number 起始数字
     * @param supplement  补充数字
     * @param length  长度
     * @return
     */
    public static String mendNumber(Integer number,Integer supplement,Integer length ) {

        String expression = "%";
        expression += supplement;
        expression += length;
        expression += "d";

        return String.format(expression, number);
    }

    /**
     * 返回特殊字符  $
     * @return
     */
    public static String getSpecialChar(int index) {
        String res;
        switch (index) {
            case 0:
                res = "$";
                break;
            case 1:
                res = "//";
                break;
            case 2:
                res = "-";
                break;
            default:
                res = "";
        }
        return res;
    }
    @Autowired
    private LogicService logicService;


//    @Scheduled(cron = "0 */1 * * * ?")
//        public void timerMainToNccDay () {
//             String dateCondition = "{aoteEncrypt:''}";
//        try {
//            logicService.xtSave ("appApplyCharge", dateCondition);
//            } catch (Exception e) {
//                e.printStackTrace ();
//            }
//
//
//        }
}
