package com.aote.handler;


import com.af.plugins.RedisTools;
import com.alibaba.fastjson.JSON;
import com.aote.file.FileManager;
import com.aote.plugins.ParameterRequestWrapper;
import com.aote.utils.AesUtils;
import com.aote.utils.FileConfig;
import com.aote.utils.ReadFile;
import com.aote.utils.SignUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InterFaceFiliterSign implements Filter {
    static Logger log = Logger.getLogger(InterFaceFiliterSign.class);
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("进入accesstoken,签名验证拦截器");
        HttpServletRequest httpServletRequest =(HttpServletRequest) request;
        HttpServletResponse httpServletResponse = (HttpServletResponse) response;
        //验签过程
        String accesskey = httpServletRequest.getHeader("accesskey");
        String sign = httpServletRequest.getHeader("sign");
        if (StringUtils.isEmpty(accesskey) || StringUtils.isEmpty(sign)) {
            resultError(701,"not accesskey or sign was found", httpServletResponse);
            return;
        }
        String secretkey = "";
        try {
            JSONObject thirdFiliter = FileConfig.getjsonfromfile("thirdFiliter.json");
            Iterator<String> keys = thirdFiliter.keys();
            //验证accesskey是否合法
            while(keys.hasNext()){
                String key = keys.next();
                JSONObject valueobject = thirdFiliter.getJSONObject(key);
                String accesskey1 = valueobject.getString("accesskey");
                if(StringUtils.isNotEmpty(accesskey1) && accesskey.equals(accesskey1)){
                    if("1".equals(valueobject.getString("isflag")) && StringUtils.isNotEmpty(valueobject.getString("secretkey"))){
                        secretkey = valueobject.getString("secretkey");
                    }
                }
            }
            if("".equals(secretkey)){
                resultError(401,"Illegal access", httpServletResponse);
                return;
            }
            String postData = getPostData(httpServletRequest);
            String template = "";
            //对参数进行解密
            String aesdecrypt = AesUtils.aesdecrypt(postData, secretkey);
            JSONObject paramsjson = new JSONObject(aesdecrypt);
            if(!paramsjson.isNull("data")){
                paramsjson = (JSONObject) paramsjson.get("data");
            }
            Map map = JSON.parseObject(paramsjson.toString() , Map.class);
            HashMap judgeArray = FileConfig.getJudgeArray(map);
            System.out.println(paramsjson.toString());
            //验证签名
            if(SignUtils.verifybd(judgeArray,secretkey,sign)){
                ParameterRequestWrapper requestWrapper = new ParameterRequestWrapper((HttpServletRequest)request);
                Iterator<String> it = paramsjson.keys();
                System.out.println(paramsjson);
                while(it.hasNext()){
                    String key = it.next();
                    requestWrapper.addParameter(key,paramsjson.get(key));
                }
                //验签通过
                log.debug("进入chain.doFilter");
                chain.doFilter(requestWrapper, response);
                log.debug("出入chain.doFilter");
            }else{
                resultError(402,"Illegal access, signature verification failed", httpServletResponse);
                return;
            }
        } catch (Exception e) {
            e.printStackTrace();
            resultError(502,"Server error", httpServletResponse);
            return;
        }

    }

    @Override
    public void destroy() {

    }
    // 返回错误提示
    public void resultError(Integer code,String errorMsg, HttpServletResponse httpServletResponse) throws IOException {
        JSONObject resultJson = new JSONObject();
        resultJson.put("code",code);
        resultJson.put("msg",new String(errorMsg.getBytes("UTF-8")));
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(new String(resultJson.toString().getBytes("UTF-8")));
    }

    private  String getPostData(HttpServletRequest request) {
        StringBuffer data = new StringBuffer();
        String line = null;
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            while (null != (line = reader.readLine()))
                data.append(line);
        } catch (IOException e) {
        } finally {
        }
        return data.toString();
    }

}
