package com.aote.handler;

import com.af.plugins.RedisTools;
import com.aote.filter.LoginFilter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;

/**
 *
 */

public class InterFaceFiliter implements Filter {
    static Logger log = Logger.getLogger(InterFaceFiliter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("进入accesstoken验证拦截器");
        HttpServletRequest httpServletRequest =(HttpServletRequest) request;
        HttpServletResponse httpServletResponse = (HttpServletResponse) response;
        String accessToken = httpServletRequest.getHeader("accesstoken");
        if (StringUtils.isEmpty(accessToken)) {
            resultError(701," this is parameter accessToken null ", httpServletResponse);
            return;
        }
        String accessKey = (String) RedisTools.getValue(accessToken);
        if (StringUtils.isEmpty(accessKey)) {
            // accessToken 已经失效!
            resultError(401," this is  accessToken Invalid ", httpServletResponse);
            return;
        }
        log.debug("进入chain.doFilter");
        chain.doFilter(request, response);
        log.debug("出入chain.doFilter");

    }

    @Override
    public void destroy() {

    }
    // 返回错误提示
    public void resultError(Integer code,String errorMsg, HttpServletResponse httpServletResponse) throws IOException {
        JSONObject resultJson = new JSONObject();
        resultJson.put("code",code);
        resultJson.put("msg",errorMsg);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(new String(resultJson.toString().getBytes("UTF-8")));
    }

}
