/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import com.af.plugins.DateTools;
import com.aote.entity.EntityServer;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AddressImport {
    static Logger log = Logger.getLogger(AddressImport.class);

    public JSONObject importUserAddress(JSONArray data, EntityServer entity, JSONObject user, SqlServer sql) throws Exception {
        long begin = System.currentTimeMillis();
        String date = DateTools.getNow2();
        HashMap<String, JSONObject> pcdlist = this.getPcdList(sql);
        HashMap<String, JSONObject> streetlist = this.getStreetList(sql);
        HashMap<String, JSONObject> arealist = this.getAreaList(sql);
        int n = 0;
        int success = 0;
        for (Object o : data) {
            Integer f_residential_area_id;
            Integer f_street_id;
            Integer f_pcd_id;
            JSONObject json = (JSONObject)o;
            JSONObject saveAddress = new JSONObject();
            saveAddress.put("f_create_person", (Object)user.getString("name"));
            saveAddress.put("f_operator", (Object)user.getString("name"));
            saveAddress.put("f_filialeid", (Object)user.getString("orgid"));
            saveAddress.put("f_orgid", (Object)user.getString("orgid"));
            saveAddress.put("f_orgname", (Object)user.getString("orgs"));
            saveAddress.put("f_depid", (Object)user.getString("depids"));
            saveAddress.put("f_depname", (Object)user.getString("parentname"));
            saveAddress.put("f_operatorid", (Object)user.getString("id"));
            JSONObject address = json.getJSONObject("t_user_address");
            String f_pcd = address.optString("f_pcd");
            String f_street = address.optString("f_street");
            String f_residential_area = address.optString("f_residential_area");
            String f_slice_area = address.optString("f_slice_area");
            if (!pcdlist.containsKey(f_pcd)) {
                f_pcd_id = null;
                JSONObject resurtjson = new JSONObject();
                resurtjson.put("type", (Object)"warning");
                resurtjson.put("msg", (Object)(n + 1 + "\u884c\u6570\u636e\u7701\u5e02\u533a\u4e0d\u5b58\u5728,\u5bfc\u5165\u5931\u8d25"));
                return resurtjson;
            }
            f_pcd_id = pcdlist.get(f_pcd).getInt("id");
            if (streetlist.containsKey(f_street)) {
                f_street_id = streetlist.get(f_street).getInt("id");
            } else {
                JSONObject streetjson = new JSONObject();
                streetjson.put("f_operator", (Object)user.getString("name"));
                streetjson.put("f_filialeid", (Object)user.getString("orgid"));
                streetjson.put("f_orgid", (Object)user.getString("orgid"));
                streetjson.put("f_orgname", (Object)user.getString("orgs"));
                streetjson.put("f_depid", (Object)user.getString("depids"));
                streetjson.put("f_depname", (Object)user.getString("parentname"));
                streetjson.put("f_operatorid", (Object)user.getString("id"));
                streetjson.put("f_pcd", (Object)f_pcd);
                streetjson.put("f_pcd_id", (Object)f_pcd_id);
                streetjson.put("f_street", (Object)f_street);
                f_street_id = Integer.parseInt(new JSONObject(entity.partialSave("t_street", streetjson)).getString("id"));
                streetjson.put("id", (Object)f_street_id);
                streetjson.put("value", (Object)f_street);
                streetlist.put(f_street, streetjson);
            }
            if (arealist.containsKey(f_residential_area)) {
                f_residential_area_id = arealist.get(f_residential_area).getInt("id");
            } else {
                JSONObject areajson = new JSONObject();
                areajson.put("f_operator", (Object)user.getString("name"));
                areajson.put("f_filialeid", (Object)user.getString("orgid"));
                areajson.put("f_orgid", (Object)user.getString("orgid"));
                areajson.put("f_orgname", (Object)user.getString("orgs"));
                areajson.put("f_depid", (Object)user.getString("depids"));
                areajson.put("f_depname", (Object)user.getString("parentname"));
                areajson.put("f_operatorid", (Object)user.getString("id"));
                areajson.put("f_pcd", (Object)f_pcd);
                areajson.put("f_pcd_id", (Object)f_pcd_id);
                areajson.put("f_street", (Object)f_street);
                areajson.put("f_street_id", (Object)f_street_id);
                areajson.put("f_residential_area", (Object)f_residential_area);
                areajson.put("f_area_address", (Object)(f_pcd + f_street));
                areajson.put("f_slice_area", (Object)f_slice_area);
                f_residential_area_id = Integer.parseInt(new JSONObject(entity.partialSave("t_area", areajson)).getString("id"));
                areajson.put("id", (Object)f_residential_area_id);
                areajson.put("value", (Object)f_residential_area);
                arealist.put(f_residential_area, areajson);
            }
            saveAddress.put("f_pcd_id", (Object)f_pcd_id);
            saveAddress.put("f_street_id", (Object)f_street_id);
            saveAddress.put("f_residential_area_id", (Object)f_residential_area_id);
            saveAddress.put("f_slice_area", (Object)f_slice_area);
            String f_building = address.optString("f_building");
            String f_unit = address.optString("f_unit");
            String f_floor = address.optString("f_floor");
            String f_room = address.optString("f_room");
            String f_address = f_pcd + f_street + f_residential_area;
            if (f_building.length() > 0) {
                String f_building_suffix = "\u680b";
                saveAddress.put("f_building_suffix", (Object)f_building_suffix);
                f_address = f_address + f_building + f_building_suffix;
            }
            if (f_unit.length() > 0) {
                String f_unit_suffix = "\u5355\u5143";
                saveAddress.put("f_unit_suffix", (Object)f_unit_suffix);
                f_address = f_address + f_unit + f_unit_suffix;
            }
            if (f_floor.length() > 0) {
                String f_floor_suffix = "\u5c42";
                saveAddress.put("f_floor_suffix", (Object)f_floor_suffix);
                f_address = f_address + f_floor + f_floor_suffix;
            }
            if (f_building.length() > 0) {
                String f_room_suffix = "\u5ba4";
                saveAddress.put("f_room_suffix", (Object)f_room_suffix);
                f_address = f_room + f_building + f_room_suffix;
            }
            saveAddress.put("f_pcd", (Object)f_pcd);
            saveAddress.put("f_street", (Object)f_street);
            saveAddress.put("f_residential_area", (Object)f_residential_area);
            saveAddress.put("f_unit", (Object)f_unit);
            saveAddress.put("f_room", (Object)f_room);
            saveAddress.put("f_floor", (Object)f_floor);
            saveAddress.put("f_building", (Object)f_building);
            saveAddress.put("f_address", (Object)f_address);
            saveAddress.put("f_create_date", (Object)date);
            try {
                entity.partialSave("t_user_address", saveAddress);
                ++success;
            }
            catch (WebException e) {
                log.warn((Object)("\u63d2\u5165\u4e00\u6761\u6570\u636e\u5f02\u5e38" + e.getMessage()));
            }
            ++n;
        }
        long end = System.currentTimeMillis();
        System.out.println("\u5bfc\u5165" + n + "\u6761,\u8017\u65f6" + (end - begin));
        System.out.println("\u6210\u529f" + success + "\u6761");
        JSONObject resurtjson2 = new JSONObject();
        resurtjson2.put("type", (Object)"success");
        resurtjson2.put("msg", (Object)("\u6210\u529f\u5bfc\u5165" + success + "\u6761"));
        return resurtjson2;
    }

    public HashMap<String, JSONObject> getPcdList(SqlServer sql) throws Exception {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONArray sqldata = sql.query("select * from t_pcd");
        for (Object o : sqldata) {
            JSONObject onedata = (JSONObject)o;
            String colunmname = onedata.getString("f_pcd");
            JSONObject json = new JSONObject();
            json.put("id", onedata.getInt("id"));
            json.put("value", (Object)colunmname);
            result.put(colunmname, json);
        }
        return result;
    }

    public HashMap<String, JSONObject> getStreetList(SqlServer sql) throws Exception {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONArray sqldata = sql.query("select * from t_street");
        for (Object o : sqldata) {
            JSONObject onedata = (JSONObject)o;
            String colunmname = onedata.getString("f_street");
            JSONObject json = new JSONObject();
            json.put("id", onedata.getInt("id"));
            json.put("value", (Object)colunmname);
            json.put("f_pcd_id", onedata.getInt("f_pcd_id"));
            json.put("f_pcd", (Object)onedata.getString("f_pcd"));
            result.put(colunmname, json);
        }
        return result;
    }

    public HashMap<String, JSONObject> getAreaList(SqlServer sql) throws Exception {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONArray sqldata = sql.query("select * from t_area");
        for (Object o : sqldata) {
            JSONObject onedata = (JSONObject)o;
            String colunmname = onedata.getString("f_residential_area");
            JSONObject json = new JSONObject();
            json.put("id", onedata.getInt("id"));
            json.put("value", (Object)colunmname);
            json.put("f_pcd_id", onedata.getInt("f_pcd_id"));
            json.put("f_pcd", (Object)onedata.getString("f_pcd"));
            json.put("f_street_id", onedata.getInt("f_street_id"));
            json.put("f_street", (Object)onedata.getString("f_street"));
            result.put(colunmname, json);
        }
        return result;
    }
}

