SELECT info.*
FROM (
      SELECT u.f_userfiles_id  AS id,
             u.f_meternumber   AS f_device_no,
             u.f_userinfo_id,
             u.f_meteread_date AS f_the_last_read_date,
             b.f_alias,
             u.f_input_date,
             'meter'           AS device_type
      FROM t_userfiles u
               JOIN t_userinfo ui ON ui.f_userinfo_id = u.f_userinfo_id
               JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
      WHERE b.f_meter_type = '物联网表'
        AND u.f_table_state IN ('正常', '停用')
        AND ui.f_user_state = '正常') info
WHERE (info.f_the_last_read_date IS NULL
    OR DATEDIFF(DAY, info.f_the_last_read_date, GETDATE()) >= ${day})
ORDER BY id;
