/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.webmeter.tools.EncodingUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class IotCodeService {
    public static long calculatePowerOfTen(Object input, int exponent) {
        if (input instanceof Number) {
            BigDecimal exponentValue;
            BigDecimal value = new BigDecimal(input.toString());
            BigDecimal result = value.multiply(exponentValue = new BigDecimal("10").pow(exponent));
            if (result.scale() > 0) {
                result = result.setScale(0, RoundingMode.DOWN);
            }
            try {
                return result.longValueExact();
            }
            catch (Exception e) {
                return -1L;
            }
        }
        if (input instanceof String) {
            try {
                BigDecimal value = new BigDecimal((String)input);
                return IotCodeService.calculatePowerOfTen(value, exponent);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public static BigDecimal calculateValue(long value, int exponent) {
        BigDecimal bdValue = new BigDecimal(value);
        BigDecimal bdExponent = BigDecimal.TEN.pow(exponent);
        return bdValue.divide(bdExponent, exponent, RoundingMode.DOWN);
    }

    public JSONObject encodeInstruction(String instructType, JSONObject params) throws Exception {
        JSONObject modelConf = this.getModelConf();
        return this.encodeInstruction(instructType, params, modelConf);
    }

    public JSONObject encodeInstruction(String instructType, JSONObject params, JSONObject config) throws Exception {
        JSONObject instructConf = this.getInstructConf(config, instructType);
        if (instructConf == null) {
            return ENCODE_RESULT.INVALID_INSTRUCT.getDescription();
        }
        return this.parseNGenerate(instructConf, params);
    }

    public JSONObject decodeInstruction(String uploadData) throws Exception {
        JSONObject modelConf = this.getModelConf();
        return this.decodeInstruction(uploadData, modelConf);
    }

    public JSONObject decodeInstruction(String uploadData, JSONObject config) throws Exception {
        JSONObject instructConf = this.getInstructConf_Decode(config, uploadData);
        if (instructConf == null) {
            return ENCODE_RESULT.INVALID_INSTRUCT.getDescription();
        }
        return this.parseNGenerate_Decode(instructConf, uploadData);
    }

    private JSONObject parseNGenerate_Decode(JSONObject instructConf, String uploadData) throws Exception {
        String responseBody = instructConf.getString("responseBody");
        JSONObject params = instructConf.getJSONObject("params");
        JSONObject result = new JSONObject();
        String[] dataFormats = responseBody.split(";");
        AtomicInteger index = new AtomicInteger(0);
        StringBuilder loopTag = new StringBuilder();
        StringBuilder loopBody = new StringBuilder();
        AtomicInteger nestingLevel = new AtomicInteger(0);
        JSONObject loopCounts = new JSONObject();
        for (String item : dataFormats) {
            if (this.loopDevice(item, loopTag, loopBody, nestingLevel, loopCounts, index, uploadData, instructConf, result) || this.parseNestedParentheses2(item = this.parseNestedParentheses1(item, result), instructConf, result, index, uploadData)) continue;
            String[] dataFormat = item.split(",");
            if (dataFormat.length < 3) {
                index.addAndGet(item.length());
                continue;
            }
            String dataFormatName = this.getDataFormatName(dataFormat);
            DATA_TYPE_ENCODE type_upload = this.getEncodeDataType(dataFormat);
            int dataFormatLen = this.getEncodeDataLength(dataFormat) * 2;
            String data = uploadData.substring(index.get(), index.get() + dataFormatLen);
            if (type_upload == DATA_TYPE_ENCODE.BIT) {
                String[] newDataFormat = new String[3];
                System.arraycopy(dataFormat, 0, newDataFormat, 0, 3);
                dataFormat = newDataFormat;
                int index_bit = 0;
                String[] dataFormats_bit = item.split("\\|");
                String data_bin = EncodingUtil.hexToBinary(data);
                for (int i = 1; i < dataFormats_bit.length; ++i) {
                    String dataFormat_bit = dataFormats_bit[i];
                    String[] dataFormat_bit_param = dataFormat_bit.split(",");
                    if (dataFormat_bit_param.length < 2) {
                        index_bit += dataFormat_bit.length();
                        continue;
                    }
                    dataFormatName = this.getDataFormatName(dataFormat_bit_param);
                    DATA_TYPE_DECODE type_result = this.getDecodeDataType(dataFormatName, params);
                    int dataFormatLen_bit = Integer.parseInt(dataFormat_bit_param[1]);
                    String data_bit = data_bin.substring(index_bit, index_bit + dataFormatLen_bit);
                    index_bit += dataFormatLen_bit;
                    int exponent = dataFormat_bit_param.length > 2 ? Integer.parseInt(dataFormat_bit_param[2]) : 0;
                    this.getValues(dataFormatName, type_upload, type_result, exponent, params, data_bit, result);
                }
            } else {
                DATA_TYPE_DECODE type_result = this.getDecodeDataType(dataFormatName, params);
                int exponent = this.getNumExponent(dataFormat);
                this.getValues(dataFormatName, type_upload, type_result, exponent, params, data, result);
            }
            if (dataFormat.length >= 5) {
                loopCounts.put(dataFormat[4], result.getInt(dataFormatName));
            }
            index.addAndGet(dataFormatLen);
        }
        result.put("DecodeLastIndex_ForRecursion", index.get());
        return ENCODE_RESULT.SUCCESS.getDescription(result);
    }

    public String parseNestedParentheses1(String input, JSONObject data) throws Exception {
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder result = new StringBuilder(input);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c == '(') {
                stack.push(i);
                continue;
            }
            if (c != ')') continue;
            if (stack.isEmpty()) {
                throw new Exception("Mismatched parentheses");
            }
            int start = (Integer)stack.pop();
            String innerExpression = result.substring(start + 1, i);
            String evaluatedExpression = this.evaluateExpression(innerExpression, data);
            result.replace(start, i + 1, evaluatedExpression);
            i = start + evaluatedExpression.length() - 1;
        }
        if (!stack.isEmpty()) {
            throw new Exception("Mismatched parentheses");
        }
        return result.toString();
    }

    public boolean parseNestedParentheses2(String input, JSONObject data, JSONObject result_final, AtomicInteger index, String uploadData) throws Exception {
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder input_ = new StringBuilder(input);
        boolean res = false;
        for (int i = 0; i < input_.length(); ++i) {
            char c = input_.charAt(i);
            if (c == '{') {
                stack.push(i);
                continue;
            }
            if (c != '}') continue;
            if (stack.isEmpty()) {
                throw new Exception("Mismatched parentheses");
            }
            res = true;
            int start = (Integer)stack.pop();
            String innerExpression = input_.substring(start + 1, i);
            this.evaluateExpression2(innerExpression, data, result_final, index, uploadData);
        }
        return res;
    }

    private String evaluateExpression(String expression, JSONObject data) {
        return data.getString(expression);
    }

    private void evaluateExpression2(String expression, JSONObject data, JSONObject result, AtomicInteger index, String uploadData) throws Exception {
        String[] expression_ = expression.split(",");
        JSONObject additionalConf = data.getJSONObject("additionalConf");
        for (int i = 0; i < expression_.length - 1; ++i) {
            additionalConf = additionalConf.getJSONObject(expression_[i]);
        }
        String conf = additionalConf.getString(expression_[expression_.length - 1]);
        JSONObject instructConf = new JSONObject(data.toString());
        instructConf.put("responseBody", (Object)conf);
        String uploadData_Recursion = uploadData.substring(index.get());
        JSONObject result_Recursion = this.parseNGenerate_Decode(instructConf, uploadData_Recursion);
        JSONObject result_Recursion_data = result_Recursion.getJSONObject("data");
        int offset = result_Recursion_data.getInt("DecodeLastIndex_ForRecursion");
        result_Recursion_data.remove("DecodeLastIndex_ForRecursion");
        EncodingUtil.mergeJSONObjects(result, result_Recursion);
        index.addAndGet(offset);
    }

    private boolean loopDevice(String item, StringBuilder loopTag, StringBuilder loopBody, AtomicInteger nestingLevel, JSONObject loopCounts, AtomicInteger index, String uploadData, JSONObject instructConf_, JSONObject result) throws Exception {
        int endIndex;
        boolean res = false;
        List<Integer> startSymbol = EncodingUtil.findCharPositions(item, '<');
        int startIndex = !startSymbol.isEmpty() ? startSymbol.get(0) + 1 : 0;
        List<Integer> endSymbol = EncodingUtil.findCharPositions(item, '>');
        int n = endIndex = !endSymbol.isEmpty() ? endSymbol.get(endSymbol.size() - 1).intValue() : item.length();
        if (!startSymbol.isEmpty()) {
            if (nestingLevel.get() == 0) {
                loopTag.setLength(0);
                loopTag.append(item, 0, startIndex - 1);
            } else {
                startIndex = 0;
            }
            nestingLevel.addAndGet(startSymbol.size());
        }
        if (!endSymbol.isEmpty()) {
            nestingLevel.addAndGet(-endSymbol.size());
            if (nestingLevel.get() == 0) {
                item = item.substring(startIndex, endIndex);
                loopBody.append(item);
                res = true;
                int loopcount = loopCounts.getInt(loopTag.toString());
                JSONObject instructConf_loop = new JSONObject();
                instructConf_loop.put("responseBody", (Object)loopBody.toString());
                instructConf_loop.put("params", instructConf_.get("params"));
                instructConf_loop.put("additionalConf", (Object)instructConf_.optJSONObject("additionalConf"));
                JSONArray result_Loop = new JSONArray();
                for (int i = 0; i < loopcount; ++i) {
                    String uploadData_Recursion = uploadData.substring(index.get());
                    JSONObject result_Recursion = this.parseNGenerate_Decode(instructConf_loop, uploadData_Recursion);
                    JSONObject result_Recursion_data = result_Recursion.getJSONObject("data");
                    int offset = result_Recursion_data.getInt("DecodeLastIndex_ForRecursion");
                    result_Recursion_data.remove("DecodeLastIndex_ForRecursion");
                    result_Loop.put((Object)result_Recursion_data);
                    index.addAndGet(offset);
                }
                result.put(loopTag.toString(), (Object)result_Loop);
            } else {
                endIndex = item.length();
            }
        }
        if (nestingLevel.get() > 0) {
            loopBody.append(item, startIndex, endIndex).append(";");
            res = true;
        }
        return res;
    }

    private void getValues(String dataFormatName, DATA_TYPE_ENCODE type_upload, DATA_TYPE_DECODE type_result, int exponent, JSONObject params, String uploadData, JSONObject result) throws Exception {
        if (type_result == DATA_TYPE_DECODE.LONG || type_result == DATA_TYPE_DECODE.DOUBLE) {
            BigDecimal value_ = this.getNumValue(type_upload, uploadData, exponent);
            if (type_result == DATA_TYPE_DECODE.LONG) {
                result.put(dataFormatName, value_.longValue());
            } else {
                result.put(dataFormatName, value_.doubleValue());
            }
        } else if (type_result == DATA_TYPE_DECODE.STRING) {
            if (type_upload == DATA_TYPE_ENCODE.BCD) {
                result.put(dataFormatName, (Object)uploadData);
            } else if (type_upload == DATA_TYPE_ENCODE.HEX || type_upload == DATA_TYPE_ENCODE.HEX_LE || type_upload == DATA_TYPE_ENCODE.BIT) {
                BigDecimal value_ = this.getNumValue(type_upload, uploadData, exponent);
                result.put(dataFormatName, (Object)value_.toString());
            }
        } else if (type_result == DATA_TYPE_DECODE.STRING_BIT) {
            if (type_upload == DATA_TYPE_ENCODE.BIT) {
                result.put(dataFormatName, (Object)EncodingUtil.reverseBinaryString(uploadData));
            } else {
                result.put(dataFormatName, (Object)EncodingUtil.hexToBinaryWithReversedBits(uploadData));
            }
        }
    }

    private BigDecimal getNumValue(DATA_TYPE_ENCODE type_upload, String uploadData, int exponent) {
        long value = 0L;
        if (type_upload == DATA_TYPE_ENCODE.BCD) {
            value = Long.parseLong(uploadData);
        } else if (type_upload == DATA_TYPE_ENCODE.HEX) {
            value = Long.parseLong(uploadData, 16);
        } else if (type_upload == DATA_TYPE_ENCODE.HEX_LE) {
            value = Long.parseLong(EncodingUtil.reverseHexStringByEndian(uploadData, EncodingUtil.Endian.LITTLE_ENDIAN), 16);
        } else if (type_upload == DATA_TYPE_ENCODE.BIT) {
            value = Long.parseLong(uploadData, 2);
        }
        return IotCodeService.calculateValue(value, exponent);
    }

    private JSONObject parseNGenerate(JSONObject instructConf, JSONObject param) throws Exception {
        String[] dataFormats;
        String requestBody = instructConf.getString("requestBody");
        JSONObject var = instructConf.getJSONObject("var");
        JSONObject params = instructConf.getJSONObject("params");
        StringBuilder result = new StringBuilder();
        for (String item : dataFormats = requestBody.split(";")) {
            if (!item.contains(",")) {
                result.append(item);
                continue;
            }
            String[] dataFormat = item.split(",");
            String dataFormatName = this.getDataFormatName(dataFormat);
            DATA_TYPE_ENCODE type_output = this.getEncodeDataType(dataFormat);
            DATA_TYPE_DECODE type_input = this.getDecodeDataType(dataFormatName, params);
            int dataFormatLen = this.getEncodeDataLength(dataFormat) * 2;
            String data = "";
            if (type_output == DATA_TYPE_ENCODE.HEX_CRC || type_output == DATA_TYPE_ENCODE.HEX_CRC_BE) {
                int[] CRCInterval = this.getCRCInterval(dataFormat);
                int beginIndex = CRCInterval[0] * 2;
                int endIndex = result.length();
                if (CRCInterval[1] > 0) {
                    endIndex = CRCInterval[1] * 2;
                }
                data = EncodingUtil.calculateCRC16(result.substring(beginIndex, endIndex), type_output == DATA_TYPE_ENCODE.HEX_CRC);
            } else if (type_output == DATA_TYPE_ENCODE.BIT) {
                StringBuilder data_bit_buffer = new StringBuilder();
                String[] dataFormats_bit = item.split("\\|");
                for (int i = 1; i < dataFormats_bit.length; ++i) {
                    String data_bit = "";
                    String dataFormat_bit = dataFormats_bit[i];
                    if (!dataFormat_bit.contains(",")) {
                        data_bit_buffer.append(dataFormat_bit);
                        continue;
                    }
                    String[] dataFormat_bit_param = dataFormat_bit.split(",");
                    dataFormatName = this.getDataFormatName(dataFormat_bit_param);
                    type_input = this.getDecodeDataType(dataFormatName, params);
                    int dataFormatLen_bit = Integer.parseInt(dataFormat_bit_param[1]);
                    int exponent_bit = dataFormat_bit_param.length > 2 ? Integer.parseInt(dataFormat_bit_param[2]) : 0;
                    data_bit = this.loadValues(dataFormatName, type_output, type_input, dataFormatLen_bit, exponent_bit, var, data_bit);
                    data_bit = this.loadValues(dataFormatName, type_output, type_input, dataFormatLen_bit, exponent_bit, param, data_bit);
                    data_bit_buffer.append(EncodingUtil.padLeft(data_bit, dataFormatLen_bit, '0', true));
                }
                data = EncodingUtil.padRight(data_bit_buffer.toString(), dataFormatLen * 4, '0', true);
                data = EncodingUtil.binaryToHex(data).toUpperCase();
            } else {
                int exponent = this.getNumExponent(dataFormat);
                data = this.loadValues(dataFormatName, type_output, type_input, dataFormatLen, exponent, var, data);
                data = this.loadValues(dataFormatName, type_output, type_input, dataFormatLen, exponent, param, data);
            }
            result.append(data);
        }
        return ENCODE_RESULT.SUCCESS.getDescription(result.toString());
    }

    private String loadValues(String dataFormatName, DATA_TYPE_ENCODE type_output, DATA_TYPE_DECODE type_input, int dataFormatLen, int exponent, JSONObject source, String data) throws Exception {
        if (source.has(dataFormatName)) {
            long value;
            Object value_ = source.get(dataFormatName);
            if (type_input == DATA_TYPE_DECODE.STRING_BIT) {
                String value_string_bit = EncodingUtil.reverseBinaryString((String)value_);
                value = Long.parseLong(value_string_bit, 2);
            } else {
                value = IotCodeService.calculatePowerOfTen(value_, exponent);
            }
            if (value != -1L) {
                if (type_output == DATA_TYPE_ENCODE.BCD) {
                    data = Long.toString(value);
                } else if (type_output == DATA_TYPE_ENCODE.HEX || type_output == DATA_TYPE_ENCODE.HEX_LE) {
                    data = Long.toHexString(value).toUpperCase();
                    if (type_output == DATA_TYPE_ENCODE.HEX_LE) {
                        data = EncodingUtil.padLeft(data, dataFormatLen, '0', true);
                        data = EncodingUtil.reverseHexStringByEndian(data, EncodingUtil.Endian.LITTLE_ENDIAN);
                    }
                } else if (type_output == DATA_TYPE_ENCODE.BIT) {
                    data = Long.toBinaryString(value);
                }
            } else if (value_ instanceof String && type_output == DATA_TYPE_ENCODE.BCD) {
                data = source.getString(dataFormatName);
            }
        }
        return EncodingUtil.padLeft(data, dataFormatLen, '0', true);
    }

    private int getNumExponent(String[] dataFormat) {
        if (dataFormat.length > 3) {
            return Integer.parseInt(dataFormat[3]);
        }
        return 0;
    }

    private int getEncodeDataLength(String[] dataFormat) throws Exception {
        if (dataFormat.length > 2) {
            return Integer.parseInt(dataFormat[2]);
        }
        throw new Exception("\u672a\u77e5\u7684\u53c2\u6570\u957f\u5ea6->" + dataFormat[0]);
    }

    private int[] getCRCInterval(String[] dataFormat) {
        int[] res = new int[]{0, 0};
        if (dataFormat.length > 3) {
            res[0] = Integer.parseInt(dataFormat[3]);
        }
        if (dataFormat.length > 4) {
            res[1] = Integer.parseInt(dataFormat[4]);
        }
        return res;
    }

    private DATA_TYPE_DECODE getDecodeDataType(String dataFormatName, JSONObject params) throws Exception {
        if (params.has(dataFormatName)) {
            return DATA_TYPE_DECODE.identifyDataType(params.getString(dataFormatName));
        }
        return DATA_TYPE_DECODE.STRING;
    }

    private DATA_TYPE_ENCODE getEncodeDataType(String[] dataFormat) throws Exception {
        if (dataFormat.length > 1) {
            return DATA_TYPE_ENCODE.identifyDataType(dataFormat[1]);
        }
        throw new Exception("\u672a\u77e5\u7684\u53c2\u6570\u7c7b\u578b->" + dataFormat[0]);
    }

    private String getDataFormatName(String[] dataFormat) throws Exception {
        if (dataFormat[0].isEmpty()) {
            throw new Exception("\u914d\u7f6e\u53c2\u6570\u9519\u8bef->" + dataFormat[0]);
        }
        return dataFormat[0];
    }

    private String processDataByType(String data, DATA_TYPE_ENCODE type) {
        if (type == DATA_TYPE_ENCODE.BCD || type == DATA_TYPE_ENCODE.HEX) {
            // empty if block
        }
        return "";
    }

    private JSONObject getInstructConf(JSONObject modelConf, String instructType) {
        JSONArray data = modelConf.getJSONArray("data");
        for (Object itemObj : data) {
            JSONObject item = (JSONObject)itemObj;
            if (!item.getString("name").equals(instructType)) continue;
            return item;
        }
        return null;
    }

    private JSONObject getInstructConf_Decode(JSONObject modelConf, String uploadData) throws Exception {
        String key = modelConf.getString("key");
        JSONArray alldata = modelConf.getJSONArray("data");
        block0: for (Object itemObj : alldata) {
            JSONObject instructConf = (JSONObject)itemObj;
            String responseBody = instructConf.getString("responseBody");
            JSONObject params = instructConf.getJSONObject("params");
            JSONObject result = new JSONObject();
            String[] dataFormats = responseBody.split(";");
            AtomicInteger index = new AtomicInteger(0);
            StringBuilder loopTag = new StringBuilder();
            StringBuilder loopBody = new StringBuilder();
            AtomicInteger nestingLevel = new AtomicInteger(0);
            JSONObject loopCounts = new JSONObject();
            for (String item : dataFormats) {
                if (this.loopDevice(item, loopTag, loopBody, nestingLevel, loopCounts, index, uploadData, instructConf, result) || this.parseNestedParentheses2(item = this.parseNestedParentheses1(item, result), instructConf, result, index, uploadData)) continue;
                String[] dataFormat = item.split(",");
                if (dataFormat.length < 3) {
                    index.addAndGet(item.length());
                    continue;
                }
                String dataFormatName = this.getDataFormatName(dataFormat);
                DATA_TYPE_ENCODE type_upload = this.getEncodeDataType(dataFormat);
                DATA_TYPE_DECODE type_input = this.getDecodeDataType(dataFormatName, params);
                JSONObject var = instructConf.getJSONObject("var");
                int dataFormatLen = this.getEncodeDataLength(dataFormat) * 2;
                String data = uploadData.substring(index.get(), index.get() + dataFormatLen);
                if (type_upload == DATA_TYPE_ENCODE.BIT) {
                    String[] newDataFormat = new String[3];
                    System.arraycopy(dataFormat, 0, newDataFormat, 0, 3);
                    dataFormat = newDataFormat;
                } else {
                    int exponent = this.getNumExponent(dataFormat);
                    if (dataFormatName.equals(key)) {
                        String keyEncode = this.loadValues(dataFormatName, type_upload, type_input, dataFormatLen, exponent, var, "");
                        if (!keyEncode.equals(data)) continue block0;
                        return instructConf;
                    }
                }
                if (dataFormat.length >= 5) {
                    loopCounts.put(dataFormat[4], result.getInt(dataFormatName));
                }
                index.addAndGet(dataFormatLen);
            }
        }
        return null;
    }

    private JSONObject getModelConf() {
        String configStr = WebMeterInfo.getString("coding");
        if (configStr != null) {
            return new JSONObject(configStr);
        }
        throw new RuntimeException("\u672a\u627e\u5230\u6a21\u5757\u5bf9\u5e94\u7684Coding\u914d\u7f6e");
    }

    static enum ENCODE_RESULT {
        SUCCESS,
        INVALID_MODULE(1, "\u65e0\u6548\u6a21\u5757\u540d"),
        INVALID_INSTRUCT(2, "\u65e0\u6548\u6307\u4ee4\u7c7b\u578b"),
        EXCEPTION(999, "\u7a0b\u5e8f\u5f02\u5e38");

        private int code = 0;
        private String description = null;

        private ENCODE_RESULT(int code, String description) {
            this.code = code;
            this.description = description;
        }

        private ENCODE_RESULT() {
        }

        public JSONObject getDescription(String data) {
            JSONObject res = new JSONObject("{\"code\":0,\"data\":\"\",\"err\":\"\"}");
            if (this.code != 0) {
                res.put("code", this.code);
                res.put("err", (Object)(this.description + ":" + data));
            } else {
                res.put("data", (Object)data);
            }
            return res;
        }

        public JSONObject getDescription(JSONObject data) {
            JSONObject res = new JSONObject("{\"code\":0,\"data\":\"\",\"err\":\"\"}");
            res.put("data", (Object)data);
            return res;
        }

        public JSONObject getDescription() {
            JSONObject res = new JSONObject("{\"code\":0,\"data\":\"\",\"err\":\"\"}");
            if (this.code != 0) {
                res.put("code", this.code);
                res.put("err", (Object)this.description);
            }
            return res;
        }
    }

    static enum DATA_TYPE_DECODE {
        LONG,
        DOUBLE,
        STRING,
        STRING_BIT;


        private static DATA_TYPE_DECODE identifyDataType(String DataType) throws Exception {
            if (DataType.equalsIgnoreCase("INT") || DataType.equalsIgnoreCase("LONG") || DataType.equalsIgnoreCase("SHORT")) {
                DataType = "LONG";
            }
            try {
                Field field = DATA_TYPE_DECODE.class.getField(DataType.toUpperCase());
                return (DATA_TYPE_DECODE)((Object)field.get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Exception("\u672a\u77e5\u7684\u53c2\u6570\u7c7b\u578b->" + DataType);
            }
        }
    }

    static enum DATA_TYPE_ENCODE {
        BCD,
        HEX,
        HEX_LE,
        HEX_CRC,
        HEX_CRC_BE,
        BIT;


        private static DATA_TYPE_ENCODE identifyDataType(String DataType) throws Exception {
            try {
                Field field = DATA_TYPE_ENCODE.class.getField(DataType.toUpperCase());
                return (DATA_TYPE_ENCODE)((Object)field.get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Exception("\u672a\u77e5\u7684\u53c2\u6570\u7c7b\u578b->" + DataType);
            }
        }
    }
}

