package com.aote.webmeter.tools.iot.onenet;

/**
 * 中国移动物联网Onenet平台接口Api（新版）
 *
 * @see <a href="https://open.iot.10086.cn/doc/v5/fuse">中国移动物联网开放平台</a>
 * @see <a href="https://open.iot.10086.cn/doc/v5/fuse/detail/1465">新版接口</>
 * @see <a href="https://open.iot.10086.cn/doc/v5/fuse/detail/1485">OneNET平台API升级情况说明</>
 */
public class OnenetApi2 {
    // 基础地址
    private static final String BASE_URL = "https://iot-api.heclouds.com";
    /**
     * 设备接口
     */
    public static final String DEVICE_URL = BASE_URL + "/device";
    /**
     * 资源接口
     */
    public static final String RESOURCE_URL = BASE_URL + "/nb-iot";
    /**
     * 命令接口
     */
    public static final String COMMAND_URL = BASE_URL + "/nb-iot/execute";
}
