package com.aote.webmeter.tools.iot;

import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.tools.iot.ctwing.CTWingApiService;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * 老版电信IOT平台指令发送工具
 * 请使用新版 CTWingApiService
 * @author Mr.river
 */
@Component
@Deprecated
public class SignalDeliveryTools {
    private static final Logger LOGGER = Logger.getLogger(SignalDeliveryTools.class);

    @Autowired
    private CTWingApiService ctWingApiService;

    /**
     * 发送命令请求（自主API）
     *
     * @param serviceId 服务ID
     * @param method    命令名称
     * @param deviceId  设备ID
     * @param jo        命令参数JSON
     * @return 请求结果JSON
     */
    public JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) throws IOException {
        return ctWingApiService.sendInstruct(serviceId,method,deviceId,jo);
    }

    public JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo) throws Exception {
        return myPostCommand(serviceId, method, deviceId, jo, 0);
    }

    /**
     * 发送透传命令请求（即时）
     *
     * @param method       命令名称
     * @param deviceId     设备ID
     * @param base64String base64编码字符串
     * @return 请求结果JSON
     */
    public JSONObject myPostCommand(String method, String deviceId, String base64String) throws IOException {
        return myPostCommand(method, deviceId, base64String, 0);
    }

    /**
     * 发送透传命令请求
     *
     * @param method       命令名称
     * @param deviceId     设备ID
     * @param base64String base64编码字符串
     * @param expireTime   等待时间
     * @return 请求结果JSON
     */
    public JSONObject myPostCommand(String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", base64String);
        return myPostCommand("RawData", method, deviceId, object, expireTime);
    }

    public JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String) throws Exception {
        return myPostCommand(serviceId, method, deviceId, base64String, 0);
    }

    public JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", base64String);
        String serviceIdValue;
        if (IotCommonTools.getIsAep() == 1) {
            serviceIdValue = serviceId;
        } else {
            serviceIdValue = "RawData";
        }
        return myPostCommand(serviceIdValue, method, deviceId, object, expireTime);
    }

    /**
     * 发送订阅请求
     *
     * @param notifyTypeEnum 订阅类型
     * @param callBackUrl    回调地址
     * @return 请求结果JSON
     */
    public JSONObject subscribe(NotifyTypeEnum notifyTypeEnum, String callBackUrl) throws IOException {
        return ctWingApiService.subscribe(notifyTypeEnum, callBackUrl);
    }

    /**
     * 删除所有订阅
     *
     * @return 请求结果JSON
     */
    public JSONObject deleteAllSubscribe() throws IOException {
        return ctWingApiService.deleteAllSubscribe();
    }
}
