package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.aote.redis.RedisUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * 表具数据缓存工具类
 * <p>
 * 目前按照300秒缓存
 */
@Component
public class MeterDataCacheUtils {

    private static final Logger LOGGER = Logger.getLogger(MeterDataCacheUtils.class);

    private static final String METERINFO_CACHE_KEY = "IotDataCache@";

    private static final Integer METERINFO_CACHE_TIME_VALUE = 300;

    /**
     * 获取缓存Key
     *
     * @param userid 主键值
     * @return key
     */
    public static String getCacheKey(Object userid, Object version) {
        return METERINFO_CACHE_KEY + "_" + userid + "_" + version;
    }

    /**
     * 获取被缓存的表具信息
     *
     * @param userid  主键id
     * @param version 版本号
     */
    public JSONObject getMeterInfo(Object userid, Object version) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        String cacheKey = getCacheKey(userid, version);
        Object result = redisUtil.get(cacheKey);
        if (result != null) {
            String str = result.toString();
            return new JSONObject(str);
        }
        return null;
    }

    /**
     * 缓存表具信息
     *
     * @param meterInfo 表具信息
     */
    public void setMeterInfo(JSONObject meterInfo) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object userid = meterInfo.get("userid");
        Object version = meterInfo.get("version");
        String cacheKey = getCacheKey(userid, version);
        redisUtil.set(cacheKey, meterInfo.toString(), METERINFO_CACHE_TIME_VALUE);
    }

    /**
     * 更新表具信息
     */
    public void updateMeterInfo(Object userid, Object version, JSONObject newMeterInfo) {
        JSONObject oldMeterInfo = getMeterInfo(userid, version);
        if (oldMeterInfo != null) {
            JsonTools.addJSON(oldMeterInfo, newMeterInfo);
            int newVersion = Integer.parseInt(version.toString()) + 1;
            oldMeterInfo.put("version", newVersion);
            setMeterInfo(oldMeterInfo);
        }
    }
}
