package com.aote.webmeter.socket.enums;

import java.util.stream.Stream;

/**
 * 消息类型
 */
public enum MsgTypeEnum {
    //正常格式
    NORMAL("NORMAL"),
    //HEX格式
    HEX("HEX"),
    //BASE64格式
    BASE64("BASE64"),
    //HEX-BASE64格式
    HEX_BASE64("HEX_BASE64");

    private final String value;

    MsgTypeEnum(String value) {
        this.value = value;
    }

    public static MsgTypeEnum toType(String value) {
        return Stream.of(MsgTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(NORMAL);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
