package com.aote.webmeter.socket.core.channel.impl;

import com.af.plugins.ConvertTools;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.channel.AbstractChannelHandler;
import com.aote.webmeter.socket.core.client.ClientManager;
import com.aote.webmeter.socket.enums.SocketTypeEnum;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;

public class DatagramPacketChannelHandler extends AbstractChannelHandler<DatagramPacket> {

    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    protected void read(ChannelHandlerContext ctx, DatagramPacket message) {
        SocketConfigItem configItem = ClientManager.getConfig();
        String address = configItem.getType().equals(SocketTypeEnum.UDP) || ctx.channel().remoteAddress() == null ? message.sender().toString() : ctx.channel().remoteAddress().toString();
        String response = runBusiness(message.content(), address);
        if (response == null || response.equals("ok") || response.equals("6f6b")) {
            return;
        }
        byte[] respBytes;
        switch (configItem.getEncodeType()) {
            case BASE64: {
                respBytes = ConvertTools.base64Decode(response.getBytes());
                break;
            }
            case HEX: {
                try {
                    respBytes = ConvertTools.hexStrToByte(response);
                } catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
                break;
            }
            case HEX_BASE64: {
                try {
                    respBytes = ConvertTools.base64Decode(ConvertTools.hexStrToByte(response));
                } catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
                break;
            }
            default: {
                respBytes = response.getBytes(StandardCharsets.UTF_8);
                break;
            }
        }
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), message.sender());
        ctx.writeAndFlush(packet);
    }
}
