package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 平台类型
 */
public enum CTWingPlatformType {
    /**
     * OC
     */
    OC(0),
    /**
     * OC2
     */
    OC2(2),
    /**
     * OC兼容AEP
     */
    AEP(1),
    /**
     * NATIVE_AEP
     */
    NATIVE_AEP(3);

    private final Integer value;

    CTWingPlatformType(Integer value) {
        this.value = value;
    }

    public static CTWingPlatformType toType(Integer value) {
        return Stream.of(CTWingPlatformType.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(Integer value) {
        return toType(value) != null;
    }

    public Integer getValue() {
        return value;
    }
}
