/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.ConvertTools;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class OnenetTools {
    private static final Logger LOGGER = Logger.getLogger(OnenetTools.class);

    public JSONObject decodeCallBackData(String encodeStr) throws DecoderException {
        String encodingAESKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_ENCODING_AES_KEY);
        if (encodingAESKey != null) {
            byte[] plainMsg;
            byte[] password = this.isNewVersion() ? encodingAESKey.getBytes(StandardCharsets.UTF_8) : ConvertTools.base64Decode((byte[])(encodingAESKey + "=").getBytes(StandardCharsets.UTF_8));
            try {
                byte[] aesMsg = ConvertTools.base64Decode((byte[])encodeStr.getBytes(StandardCharsets.UTF_8));
                plainMsg = OnenetTools.decrypt(aesMsg, password);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String str = new String(plainMsg, StandardCharsets.UTF_8);
            LOGGER.info((Object)("onenetDecodeCallBackData:" + str));
            return new JSONObject(str.substring(str.indexOf("{")));
        }
        JSONObject result = new JSONObject(encodeStr);
        if (result.has("value")) {
            result.put("value", (Object)new String(ConvertTools.hexStrToByte((String)result.getString("value")), StandardCharsets.UTF_8));
        }
        return result;
    }

    private static byte[] decrypt(byte[] encrypted, byte[] password) throws Exception {
        byte[] bs = new byte[16];
        System.arraycopy(password, 0, bs, 0, 16);
        IvParameterSpec zeroIv = new IvParameterSpec(bs);
        SecretKeySpec key = new SecretKeySpec(password, "AES");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(2, (Key)key, zeroIv);
        return cipher.doFinal(encrypted);
    }

    public boolean isNewVersion() {
        return WebMeterInfo.has(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
    }
}

