/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.webmeter.tools.Util;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class BasicTools {
    private static final Logger LOGGER;
    private static final String PORT;
    private static final String SIMPLE_URL;
    private static final String LOCAL_URL;

    public static String getPort() {
        return PORT != null ? PORT : "8445";
    }

    public static String getLocalUrl() {
        return LOCAL_URL != null ? LOCAL_URL : "http://localhost:8445/webmeter/";
    }

    public static String getSimpleUrl() {
        return SIMPLE_URL != null ? LOCAL_URL : "http://localhost:8445/";
    }

    public static void sleep(Integer millis) throws InterruptedException {
        Thread.sleep(millis.intValue());
    }

    public static JSONArray formatStairArray(JSONObject object, Integer gasMaxValue) {
        JSONArray result = new JSONArray();
        for (int i = 1; i <= object.length(); ++i) {
            if (!object.has("f_stair" + i + "price")) continue;
            JSONObject stair = new JSONObject();
            stair.put("f_price", (Object)Util.convertBigDecimal(object.get("f_stair" + i + "price")));
            int gas = Util.convertBigDecimal(object.get("f_stair" + i + "amount")).intValue();
            if (gas > gasMaxValue || gas < 0) {
                stair.put("f_gas", gasMaxValue + i);
            } else {
                stair.put("f_gas", gas);
            }
            result.put((Object)stair);
        }
        return BasicTools.formatStairArray(result);
    }

    public static JSONArray formatStairArray(JSONObject object, Integer gasMaxValue, Boolean isHeat) {
        return BasicTools.formatStairArray(object, gasMaxValue);
    }

    public static JSONArray formatStairArray(JSONObject object) {
        return BasicTools.formatStairArray(object, (Integer)6550);
    }

    public static JSONArray formatStairArray(JSONArray array, Integer gasMaxValue, Boolean isHeat) {
        JSONArray result = new JSONArray();
        JSONObject item = null;
        int length = array.length();
        if (length < 3) {
            length = 3;
        }
        for (int i = 0; i < length; ++i) {
            if (array.length() >= i + 1) {
                item = array.getJSONObject(i);
                int gas = item.getInt("f_gas");
                if (isHeat.booleanValue()) {
                    item.put("f_gas", gas += item.getInt("f_add_gas_heat"));
                }
                if (gas > gasMaxValue || gas < 0) {
                    item.put("f_gas", gasMaxValue + i);
                }
                result.put((Object)item);
                continue;
            }
            if (item == null) continue;
            item.put("f_gas", gasMaxValue + i);
            result.put((Object)item);
        }
        return result;
    }

    public static JSONArray formatStairArray(JSONArray array, Integer gasMaxValue) {
        return BasicTools.formatStairArray(array, gasMaxValue, (Boolean)false);
    }

    public static JSONArray formatStairArray(JSONArray array, Integer gasMaxValue, String addGas) {
        JSONArray result = new JSONArray();
        JSONObject item = null;
        int length = array.length();
        if (length < 3) {
            length = 3;
        }
        for (int i = 0; i < length; ++i) {
            if (array.length() >= i + 1) {
                item = array.getJSONObject(i);
                int gas = item.getInt("f_gas") + Integer.parseInt(addGas);
                if (gas > gasMaxValue || gas < 0) {
                    item.put("f_gas", gasMaxValue + i);
                } else {
                    item.put("f_gas", gas);
                }
                result.put((Object)item);
                continue;
            }
            if (item == null) continue;
            item.put("f_gas", gasMaxValue + i);
            result.put((Object)item);
        }
        return result;
    }

    public static JSONArray formatStairArray(JSONArray array) {
        return BasicTools.formatStairArray(array, (Integer)6550);
    }

    static {
        boolean isOK;
        LOGGER = Logger.getLogger(BasicTools.class);
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = null;
        try {
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("org.apache.coyote.http11.Http11AprProtocol")));
            isOK = true;
        }
        catch (Exception e) {
            try {
                objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
                isOK = true;
            }
            catch (MalformedObjectNameException e2) {
                LOGGER.error((Object)"\u83b7\u53d6\u670d\u52a1\u7aef\u53e3\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a");
                isOK = false;
            }
        }
        PORT = isOK && objectNames.iterator().hasNext() ? objectNames.iterator().next().getKeyProperty("port") : "8445";
        SIMPLE_URL = "http://localhost:" + PORT + "/";
        LOCAL_URL = SIMPLE_URL + "webmeter/";
        LOGGER.debug((Object)("\u672c\u5730Tomcat\u670d\u52a1\u5730\u5740\uff1a" + LOCAL_URL));
    }
}

