/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket.core.client;

import com.af.plugins.ConvertTools;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.channel.ChannelData;
import io.netty.channel.Channel;
import io.netty.util.HashedWheelTimer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManager.class);
    private static final Map<String, ChannelData> clientChannels = new ConcurrentHashMap<String, ChannelData>();
    private static final ThreadLocal<String> channelIdLocal = new ThreadLocal();
    private static volatile HashedWheelTimer TIMER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashedWheelTimer getTimer() {
        if (TIMER != null) return TIMER;
        Class<ClientManager> clazz = ClientManager.class;
        synchronized (ClientManager.class) {
            if (TIMER != null) return TIMER;
            TIMER = new HashedWheelTimer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return TIMER;
        }
    }

    public static void setChannelId(String channelId) {
        channelIdLocal.set(channelId);
    }

    public static void add(String channelId, ChannelData channelData) {
        clientChannels.put(channelId, channelData);
    }

    public static void remove() {
        String channelId = channelIdLocal.get();
        if (channelId != null) {
            clientChannels.remove(channelId);
            channelIdLocal.remove();
        }
    }

    public static void delayedSend(Object sleepTime, String message) {
        ClientManager.getTimer().newTimeout(timeout -> {
            try {
                ClientManager.send(message);
            }
            catch (Exception e) {
                LOGGER.error("\u5ef6\u65f6\u53d1\u9001\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, Long.parseLong(sleepTime.toString()), TimeUnit.MILLISECONDS);
    }

    public static void send(String message) throws DecoderException {
        byte[] sendMsgBytes;
        if (message == null || message.equals("ok") || message.equals("6f6b")) {
            return;
        }
        String channelId = channelIdLocal.get();
        ChannelData channelData = clientChannels.get(channelId);
        Channel channel = channelData.getChannel();
        LOGGER.debug("\u8fd4\u56de\u6570\u636e\u8fde\u63a5,channel\uff1a{}", (Object)channel);
        if (channel != null) {
            String address = channel.remoteAddress().toString();
            LOGGER.debug("channelId:{}, address:{}, \u5411\u5ba2\u6237\u7aef\u53d1\u9001\u6d88\u606f", (Object)channelId, (Object)address);
            switch (channelData.getConfigItem().getEncodeType()) {
                case BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])message.getBytes());
                    break;
                }
                case HEX: {
                    sendMsgBytes = ConvertTools.hexStrToByte((String)message);
                    break;
                }
                case HEX_BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
                    break;
                }
                default: {
                    sendMsgBytes = message.getBytes();
                }
            }
        } else {
            throw new RuntimeException("channel\u4e3a\u7a7a\uff01");
        }
        channel.writeAndFlush((Object)channel.alloc().buffer().writeBytes(sendMsgBytes));
    }

    public static SocketConfigItem getConfig() {
        return ClientManager.getChannelData().getConfigItem();
    }

    public static ChannelData getChannelData() {
        String channelId = channelIdLocal.get();
        return clientChannels.get(channelId);
    }

    public static void setGlobalParams(String key, Object value) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.getGlobalParams();
        globalParamsItem.put(key, value);
    }

    public static Object getGlobalParams(String key) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.getGlobalParams();
        return globalParamsItem.opt(key);
    }
}

