/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket.config;

import com.af.plugins.JsonTools;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.enums.SocketTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SocketConfig {
    private static final List<SocketConfigItem> socketConfigItemList;

    public static List<SocketConfigItem> getSocketServerList() {
        return socketConfigItemList;
    }

    public static void setSocketConfigItem(JSONObject params, SocketTypeEnum typeEnum) {
        String name = params.getString("name");
        String logicName = params.getString("callBackName");
        JSONArray ports = params.getJSONArray("port");
        String msgReceiveType = params.getString("msgReceiveType");
        String msgSendType = params.getString("msgSendType");
        String channelDataName = params.optString("getChannelDataName", null);
        SocketConfigItem socketConfigItem = new SocketConfigItem();
        socketConfigItem.setName(name);
        socketConfigItem.setType(typeEnum.getValue());
        socketConfigItem.setPort(ports.toList());
        socketConfigItem.setDecodeType(msgReceiveType);
        socketConfigItem.setEncodeType(msgSendType);
        socketConfigItem.setLogicName(logicName);
        socketConfigItemList.add(socketConfigItem);
    }

    static {
        JSONArray array2;
        Throwable throwable;
        InputStream inputStream;
        socketConfigItemList = new ArrayList<SocketConfigItem>();
        try {
            inputStream = SocketConfig.class.getClassLoader().getResourceAsStream("config/server/TCPListenerConfig.json");
            throwable = null;
            try {
                if (inputStream != null) {
                    array2 = JsonTools.readJsonArrayFile((String)"config/server/TCPListenerConfig.json");
                    array2.forEach(item -> {
                        JSONObject params = (JSONObject)item;
                        SocketConfig.setSocketConfigItem(params, SocketTypeEnum.TCP);
                    });
                }
            }
            catch (Throwable array2) {
                throwable = array2;
                throw array2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable array2) {
                            throwable.addSuppressed(array2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            inputStream = SocketConfig.class.getClassLoader().getResourceAsStream("config/server/UDPListenerConfig.json");
            throwable = null;
            try {
                if (inputStream != null) {
                    array2 = JsonTools.readJsonArrayFile((String)"config/server/UDPListenerConfig.json");
                    array2.forEach(item -> {
                        JSONObject params = (JSONObject)item;
                        SocketConfig.setSocketConfigItem(params, SocketTypeEnum.UDP);
                    });
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

