/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.pinpad.Pinpad;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.SystemPropertiesManager;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.pinpad.TusnInfo;
import java.util.Date;

public class SystemInfomation {
    public static final int DEVELOP_STATE_UNKNOWN = -1;
    public static final int DEVELOP_STATE_PRODUCE = 0;
    public static final int DEVELOP_STATE_NORMAL = 1;
    public static final int DEVELOP_STATE_MAINTAIN = 2;
    public static final int DEVELOP_STATE_MOCKUP = 3;
    public static final int EM_CID_LCD = 1;
    public static final int EM_CID_PRINTERTYPE = 2;
    public static final int EM_CID_MAGCARDTYPE = 4;
    public static final int EM_CID_USBD = 8;
    public static final int EM_CID_USBH = 16;
    public static final int EM_CID_ICCARD = 32;
    public static final int EM_CID_SAM = 64;
    public static final int EM_CID_PINPAD = 128;
    public static final int EM_CID_UART = 256;
    public static final int EM_CID_KEYBOARD = 512;
    public static final int EM_CID_MODEM = 1024;
    public static final int EM_CID_WIRELESS = 2048;
    public static final int EM_CID_ETHERNET = 4096;
    public static final int EM_CID_RFCARD = 8192;
    public static final int EM_CID_WIFI = 16384;
    public static final int EM_CID_SDCARD = 32768;
    public static final int EM_CID_AUDIO = 65536;
    public static final int EM_CID_PRODUCT = 131072;
    public static final int EM_CID_FSK = 524288;
    private static final String RO_EPAY_MODE = "ro.epay.mode";

    private SystemInfomation() {
    }

    public static int getDevelopState() {
        return SystemInfomation.getDeviceMode().value;
    }

    public static DeviceMode getDeviceMode() {
        String state;
        switch (state = SystemPropertiesManager.getProperty(RO_EPAY_MODE, "-1")) {
            case "0": {
                return DeviceMode.STATE_PRODUCE;
            }
            case "1": {
                return DeviceMode.STATE_NORMAL;
            }
            case "2": {
                return DeviceMode.STATE_MAINTAIN;
            }
            case "3": {
                return DeviceMode.STATE_MOCKUP;
            }
        }
        return DeviceMode.STATE_UNKNOWN;
    }

    public static boolean setCurrentDateTime(Date dateTime) {
        Parcel data = Parcel.obtain();
        data.writeLong(dateTime.getTime());
        try {
            MasterController.getInstance().request(-2147483647, data);
            boolean bl = true;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        finally {
            data.recycle();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setCurrentDateTime(String packageName, Date dateTime) {
        Parcel data = Parcel.obtain();
        data.writeLong(dateTime.getTime());
        try {
            MasterController.getInstance().request(packageName, -2147483647, data);
            boolean bl = true;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        finally {
            data.recycle();
        }
        return false;
    }

    public static DeviceInfo getDeviceInfo() {
        DeviceInfo info = new DeviceInfo();
        String sn = SystemInfomation.getSerialNo();
        info.hardwareSn = sn;
        info.specialPSamId = SystemInfomation.getSpecialPsamID();
        info.specialSerialNo = SystemInfomation.getSpecialSn();
        if (sn == null || !sn.startsWith("S") || sn.length() <= 1) {
            info.terminalType = "";
            info.version = "";
            info.serialNo = "";
            return info;
        }
        try {
            int offset = 1;
            int tmLen = sn.charAt(offset++) - 48;
            info.terminalType = sn.substring(offset, offset + tmLen);
            offset += tmLen;
            int vLen = sn.charAt(offset++) - 48;
            info.version = sn.substring(offset, offset + vLen);
            offset += vLen;
            int sLen = sn.charAt(offset++) - 48;
            info.serialNo = sn.substring(offset, offset + sLen);
            offset += sLen;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TusnInfo getTUSN(int mode, byte[] input) {
        Pinpad pinpad = new Pinpad(0, "IPP");
        if (!pinpad.open()) {
            return null;
        }
        try {
            TusnInfo tusnInfo = pinpad.getTUSN(mode, input);
            return tusnInfo;
        }
        finally {
            pinpad.close();
        }
    }

    public static boolean isModuleExist(int moduleId) {
        IntegerBuffer buffer = new IntegerBuffer();
        int iRet = SystemInfomation.getConfig(buffer);
        if (iRet != 0) {
            return false;
        }
        int config = buffer.getData();
        return (config & moduleId) == moduleId;
    }

    public static native String getSystemVersion();

    public static native int getConfig(IntegerBuffer var0);

    private static native String getSerialNo();

    private static native String getSpecialPsamID();

    private static native String getSpecialSn();

    static {
        System.loadLibrary("eptand_jni");
    }

    public static class DeviceInfo {
        private String serialNo;
        private String terminalType;
        private String version;
        private String specialSerialNo;
        private String specialPSamId;
        private String hardwareSn;

        public String getTerminalType() {
            return this.terminalType;
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSpecialPSamId() {
            return this.specialPSamId;
        }

        public String getSpecialSerialNo() {
            return this.specialSerialNo;
        }

        public String getHardWareSn() {
            return this.hardwareSn;
        }
    }

    public static enum DeviceMode {
        STATE_UNKNOWN(-1),
        STATE_PRODUCE(0),
        STATE_NORMAL(1),
        STATE_MAINTAIN(2),
        STATE_MOCKUP(3);

        private int value;

        private DeviceMode(int value) {
            this.value = value;
        }
    }
}

