/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Printer;
import com.landicorp.android.eptapi.utils.IHandler;
import java.util.LinkedList;
import java.util.List;

public class PausableHandler
implements IHandler {
    public static final int TIMEMODE_PAUSE = 0;
    public static final int TIMEMODE_RECOUNT = 1;
    public static final int TIMEMODE_IN_BACKGROUND = 2;
    private IHandler currentState;
    private CommonState commonState;
    private PauseState pauseState;
    private List<MessageItem> messages;
    private Handler handler;
    private int timeMode = 0;
    private Handler.Callback callback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            PausableHandler.this.handleMessage(msg);
            return true;
        }
    };

    public PausableHandler() {
        this(Looper.getMainLooper(), 0);
    }

    public PausableHandler(int timeMode) {
        this(Looper.getMainLooper(), timeMode);
    }

    public PausableHandler(Looper l, int timeMode) {
        this.timeMode = timeMode;
        this.handler = new Handler(l, this.callback);
        this.messages = new LinkedList<MessageItem>();
        this.commonState = new CommonState();
        this.currentState = this.commonState;
        this.pauseState = new PauseState();
    }

    public synchronized void pause() {
        if (this.currentState == this.pauseState) {
            return;
        }
        this.handler.removeCallbacksAndMessages(null);
        switch (this.timeMode) {
            case 0: {
                this.commonState.updateDelayedMillis();
                break;
            }
            case 1: {
                break;
            }
        }
        this.currentState = this.pauseState;
    }

    public synchronized void resume() {
        if (this.currentState == this.commonState) {
            return;
        }
        switch (this.timeMode) {
            case 2: {
                this.commonState.updateDelayedMillis();
                break;
            }
        }
        this.commonState.postAllMessageItems();
        this.currentState = this.commonState;
    }

    @Override
    public boolean sendEmptyMessage(int what) {
        return this.currentState.sendEmptyMessage(what);
    }

    @Override
    public boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
        return this.currentState.sendEmptyMessageAtTime(what, uptimeMillis);
    }

    @Override
    public boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        return this.currentState.sendEmptyMessageDelayed(what, delayMillis);
    }

    @Override
    public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
        return this.currentState.sendMessageAtTime(msg, uptimeMillis);
    }

    @Override
    public boolean sendMessageDelayed(Message msg, long delayMillis) {
        return this.currentState.sendMessageDelayed(msg, delayMillis);
    }

    @Override
    public boolean sendMessage(Message msg) {
        return this.currentState.sendMessage(msg);
    }

    @Override
    public boolean sendMessageAtFrontOfQueue(Message msg) {
        return this.currentState.sendMessageAtFrontOfQueue(msg);
    }

    public void handleMessage(Message msg) {
    }

    @Override
    public void dispatchMessage(Message msg) {
        this.currentState.dispatchMessage(msg);
    }

    @Override
    public Message obtainMessage() {
        return this.currentState.obtainMessage();
    }

    @Override
    public Message obtainMessage(int what) {
        return this.currentState.obtainMessage(what);
    }

    @Override
    public Message obtainMessage(int what, Object obj) {
        return this.currentState.obtainMessage(what, obj);
    }

    @Override
    public Message obtainMessage(int what, int arg1, int arg2) {
        return this.currentState.obtainMessage(what, arg1, arg2);
    }

    @Override
    public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        return this.currentState.obtainMessage(what, arg1, arg2, obj);
    }

    @Override
    public boolean post(Runnable r) {
        return this.currentState.post(r);
    }

    @Override
    public boolean postAtTime(Runnable r, long uptimeMillis) {
        return this.currentState.postAtTime(r, uptimeMillis);
    }

    @Override
    public boolean postAtTime(Runnable r, Object token, long uptimeMillis) {
        return this.currentState.postAtTime(r, token, uptimeMillis);
    }

    @Override
    public boolean postDelayed(Runnable r, long delayMillis) {
        return this.currentState.postDelayed(r, delayMillis);
    }

    @Override
    public boolean postAtFrontOfQueue(Runnable r) {
        return this.currentState.postAtFrontOfQueue(r);
    }

    @Override
    public void removeCallbacks(Runnable r) {
        this.currentState.removeCallbacks(r);
    }

    @Override
    public void removeCallbacks(Runnable r, Object token) {
        this.currentState.removeCallbacks(r, token);
    }

    @Override
    public void removeMessages(int what) {
        this.currentState.removeMessages(what);
    }

    @Override
    public void removeMessages(int what, Object object) {
        this.currentState.removeMessages(what, object);
    }

    @Override
    public void removeCallbacksAndMessages(Object token) {
        this.currentState.removeCallbacksAndMessages(token);
    }

    @Override
    public boolean hasMessages(int what) {
        return this.currentState.hasMessages(what);
    }

    @Override
    public boolean hasMessages(int what, Object object) {
        return this.currentState.hasMessages(what, object);
    }

    @Override
    public Looper getLooper() {
        return this.currentState.getLooper();
    }

    @Override
    public void dump(Printer pw, String prefix) {
        this.currentState.dump(pw, prefix);
    }

    class MessageItem
    implements Runnable {
        private long uptimeMillisOnCreate = SystemClock.uptimeMillis();
        private long delayedMillis;
        private Message message;
        private Runnable callback;
        private Object token;

        MessageItem(Runnable r, long delayedMillis) {
            this.setCallback(r);
            this.delayedMillis = delayedMillis;
            if (delayedMillis < 0L) {
                delayedMillis = 0L;
            }
        }

        MessageItem(Runnable r, Object token, long delayedMillis) {
            this.setCallback(r);
            this.setToken(token);
            this.delayedMillis = delayedMillis;
            if (delayedMillis < 0L) {
                delayedMillis = 0L;
            }
        }

        MessageItem(Message message, long delayedMillis) {
            this.setMessage(message);
            this.delayedMillis = delayedMillis;
            if (delayedMillis < 0L) {
                delayedMillis = 0L;
            }
        }

        MessageItem() {
        }

        MessageItem(Runnable r) {
            this.setCallback(r);
        }

        MessageItem(Message message) {
            this.message = message;
        }

        Message getMessage() {
            return this.message;
        }

        void setMessage(Message message) {
            this.message = message;
        }

        public Runnable getCallback() {
            return this.callback;
        }

        public void setCallback(Runnable callback) {
            this.callback = callback;
        }

        public Object getToken() {
            return this.token;
        }

        public void setToken(Object token) {
            this.token = token;
        }

        long getWhen() {
            return this.uptimeMillisOnCreate + this.delayedMillis;
        }

        public void setUptimeMillis(long m) {
            this.uptimeMillisOnCreate = m;
        }

        void updateDelayedMillis(long now) {
            long when = this.getWhen();
            if (when > now) {
                this.delayedMillis -= now - this.uptimeMillisOnCreate;
                if (this.delayedMillis < 0L) {
                    this.delayedMillis = 0L;
                }
            } else {
                this.delayedMillis = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.remove(this);
            }
            if (this.getCallback() != null) {
                this.getCallback().run();
                return;
            }
            this.message.getTarget().dispatchMessage(this.message);
        }
    }

    class PauseState
    extends CommonState {
        PauseState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessage(int what) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(this.obtainMessage(what)));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(this.obtainMessage(what), uptimeMillis));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessageDelayed(int what, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(this.obtainMessage(what), delayMillis));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(msg, uptimeMillis));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageDelayed(Message msg, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(msg, delayMillis));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessage(Message msg) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(msg));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageAtFrontOfQueue(Message msg) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(msg);
                item.setUptimeMillis(0L);
                PausableHandler.this.messages.add(item);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean post(Runnable r) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r);
                item.setUptimeMillis(0L);
                PausableHandler.this.messages.add(item);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtTime(Runnable r, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(r, uptimeMillis - SystemClock.uptimeMillis()));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtTime(Runnable r, Object token, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(r, token, uptimeMillis - SystemClock.uptimeMillis()));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postDelayed(Runnable r, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(r, delayMillis));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtFrontOfQueue(Runnable r) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                PausableHandler.this.messages.add(new MessageItem(r));
            }
            return true;
        }
    }

    class CommonState
    implements IHandler {
        @Override
        public void dispatchMessage(Message msg) {
            PausableHandler.this.handler.dispatchMessage(msg);
        }

        @Override
        public Message obtainMessage() {
            return PausableHandler.this.handler.obtainMessage();
        }

        @Override
        public Message obtainMessage(int what) {
            return PausableHandler.this.handler.obtainMessage(what);
        }

        @Override
        public Message obtainMessage(int what, Object obj) {
            return PausableHandler.this.handler.obtainMessage(what, obj);
        }

        @Override
        public Message obtainMessage(int what, int arg1, int arg2) {
            return PausableHandler.this.handler.obtainMessage(what, arg1, arg2);
        }

        @Override
        public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
            return PausableHandler.this.handler.obtainMessage(what, arg1, arg2, obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean post(Runnable r) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.post((Runnable)item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtTime(Runnable r, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r, uptimeMillis - SystemClock.uptimeMillis());
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtTime(Runnable r, Object token, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r, token, uptimeMillis - SystemClock.uptimeMillis());
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, token, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postDelayed(Runnable r, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r, delayMillis);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean postAtFrontOfQueue(Runnable r) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(r);
                item.setUptimeMillis(0L);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtFrontOfQueue((Runnable)item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallbacks(Runnable r) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                int i = 0;
                while (i < PausableHandler.this.messages.size()) {
                    MessageItem item = (MessageItem)PausableHandler.this.messages.get(i);
                    if (item.getCallback() == r) {
                        PausableHandler.this.messages.remove(i);
                        PausableHandler.this.handler.removeCallbacks((Runnable)item);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallbacks(Runnable r, Object token) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                int i = 0;
                while (i < PausableHandler.this.messages.size()) {
                    MessageItem item = (MessageItem)PausableHandler.this.messages.get(i);
                    if (item.getCallback() == r && item.getToken() == token) {
                        PausableHandler.this.messages.remove(i);
                        PausableHandler.this.handler.removeCallbacks((Runnable)item, token);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessage(Message msg) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(msg);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.post((Runnable)item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessage(int what) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(PausableHandler.this.handler.obtainMessage(what));
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.post((Runnable)item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessageDelayed(int what, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(PausableHandler.this.handler.obtainMessage(what), delayMillis);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(PausableHandler.this.handler.obtainMessage(what, (Object)uptimeMillis), uptimeMillis);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageDelayed(Message msg, long delayMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(msg, delayMillis);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(msg, uptimeMillis);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendMessageAtFrontOfQueue(Message msg) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                MessageItem item = new MessageItem(msg);
                item.setUptimeMillis(0L);
                PausableHandler.this.messages.add(item);
                return PausableHandler.this.handler.postAtFrontOfQueue((Runnable)item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMessages(int what) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                int i = 0;
                while (i < PausableHandler.this.messages.size()) {
                    MessageItem item = (MessageItem)PausableHandler.this.messages.get(i);
                    Message m = item.getMessage();
                    if (m != null && m.what == what) {
                        PausableHandler.this.messages.remove(i);
                        PausableHandler.this.handler.removeCallbacks((Runnable)item);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMessages(int what, Object object) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                int i = 0;
                while (i < PausableHandler.this.messages.size()) {
                    MessageItem item = (MessageItem)PausableHandler.this.messages.get(i);
                    Message m = item.getMessage();
                    if (m != null && m.what == what && item.getToken() == object) {
                        PausableHandler.this.messages.remove(i);
                        PausableHandler.this.handler.removeCallbacks((Runnable)item);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallbacksAndMessages(Object token) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                int i = 0;
                while (i < PausableHandler.this.messages.size()) {
                    MessageItem item = (MessageItem)PausableHandler.this.messages.get(i);
                    if (item != null && item.getToken() == token) {
                        PausableHandler.this.messages.remove(i);
                        continue;
                    }
                    ++i;
                }
                PausableHandler.this.handler.removeCallbacksAndMessages(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMessages(int what) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                for (MessageItem item : PausableHandler.this.messages) {
                    Message m = item.getMessage();
                    if (m == null || m.what != what) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMessages(int what, Object object) {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                for (MessageItem item : PausableHandler.this.messages) {
                    Message m = item.getMessage();
                    if (m == null || m.what != what || item.getToken() != object) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postAllMessageItems() {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                long now = SystemClock.uptimeMillis();
                for (MessageItem item : PausableHandler.this.messages) {
                    if (item.getWhen() != 0L) {
                        item.setUptimeMillis(now);
                    }
                    PausableHandler.this.handler.postAtTime((Runnable)item, item.getWhen());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateDelayedMillis() {
            List list = PausableHandler.this.messages;
            synchronized (list) {
                long now = SystemClock.uptimeMillis();
                for (MessageItem item : PausableHandler.this.messages) {
                    item.updateDelayedMillis(now);
                }
            }
        }

        @Override
        public Looper getLooper() {
            return PausableHandler.this.handler.getLooper();
        }

        @Override
        public void dump(Printer pw, String prefix) {
            PausableHandler.this.handler.dump(pw, prefix);
        }
    }
}

