/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import android.text.TextUtils;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IODCode;

public class OdCode {
    static final int ENCODE_SUCCESS = 0;
    public static final int ECTYPE_CODE39 = 0;
    public static final int ECTYPE_CODE128 = 1;
    public static final int ECTYPE_UCC_EAN128 = 2;
    public static final int ECTYPE_EAN13 = 3;
    public static final int ECTYPE_EAN8 = 4;
    public static final int ECTYPE_UPC_A = 5;
    public static final int ECTYPE_UPC_E = 6;
    public static final int ECTYPE_INTER_LEAVED25 = 7;
    public static final int ECTYPE_CODABAR = 8;
    public static final int ECTYPE_CODE93 = 9;
    private int ecType;
    private String codeData;
    private IODCode idCode;

    public OdCode(String data) {
        this(8, data);
    }

    public OdCode(int ecType, String data) {
        OdCode.checkEncodeType(ecType);
        this.ecType = ecType;
        this.codeData = data;
        this.idCode = this.create1DCode();
    }

    private IODCode create1DCode() {
        return new IODCode();
    }

    public boolean covertToBmpData(BytesBuffer buffer) {
        return this.covertToBmpData(this.ecType, buffer);
    }

    public boolean covertToBmpData(int ecType, BytesBuffer buffer) {
        OdCode.checkEncodeType(ecType);
        OdCode.checkNotNull(buffer);
        return this.idCode.create1DCode(this.codeData, ecType, buffer) == 0;
    }

    public boolean covertToBmpData(int codeWith, int expectedWidth, int expectedHeight, BytesBuffer buffer) {
        return this.covertToBmpData(this.ecType, codeWith, expectedWidth, expectedHeight, buffer);
    }

    public boolean covertToBmpData(int ecType, int codeWith, int expectedWidth, int expectedHeight, BytesBuffer buffer) {
        OdCode.checkEncodeType(ecType);
        OdCode.checkNotNull(buffer);
        OdCode.checkImageFactor(codeWith, expectedWidth, expectedHeight);
        return this.idCode.create1DCodeWithExpectedWHBuff(buffer, ecType, codeWith, expectedWidth, expectedHeight, this.codeData) == 0;
    }

    public boolean covertToBmpFile(String imagePath, int codeWith, int expectedWidth, int expectedHeight) {
        return this.covertToBmpFile(this.ecType, imagePath, codeWith, expectedWidth, expectedHeight);
    }

    public boolean covertToBmpFile(int ecType, String imagePath, int codeWith, int expectedWidth, int expectedHeight) {
        OdCode.checkEncodeType(ecType);
        OdCode.checkFilePath(imagePath);
        OdCode.checkImageFactor(codeWith, expectedWidth, expectedHeight);
        return this.idCode.create1DCodeWithExpectedWHFile(imagePath, ecType, codeWith, expectedWidth, expectedHeight, this.codeData) == 0;
    }

    private static void checkEncodeType(int ecType) {
        if (ecType < 0 || ecType > 9) {
            throw new IllegalArgumentException("ecType is not valid!");
        }
    }

    private static void checkImageFactor(int codeWidth, int expectedWidth, int expectedHeight) {
        if (codeWidth <= 0 || codeWidth > 8) {
            throw new IllegalArgumentException("codeWidth must between 1 ~ 8.");
        }
        if (expectedWidth <= 0) {
            throw new IllegalArgumentException("expectedWidth must be grater than 0.");
        }
        if (expectedHeight <= 0) {
            throw new IllegalArgumentException("expectedWidth must be grater than 0.");
        }
    }

    private static void checkFilePath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException("file patch can't be empty!");
        }
    }

    private static void checkNotNull(BytesBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer can't be null!");
        }
    }
}

