/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.BmpUtil;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageTransformer {
    static final Logger logger = Logger.getLogger(ImageTransformer.class);
    static final byte MARK_B = 66;
    static final byte MARK_M = 77;
    static final int BMP_FILE_HEADER_SIZE = 14;
    static final int BMP_INFO_HEADER_SIZE = 40;
    static final int BMP_HEAD_SIZE = 54;

    private ImageTransformer() {
    }

    public static boolean isBmpFile(byte[] imageData) {
        if (imageData == null || imageData.length < 14) {
            return false;
        }
        int reserved1 = ImageTransformer.getShort(imageData, 6);
        int reserved2 = ImageTransformer.getShort(imageData, 8);
        return imageData[0] == 66 && imageData[1] == 77 && reserved1 == 0 && reserved2 == 0;
    }

    public static boolean isMonoBmpFile(byte[] imageData) {
        if (!ImageTransformer.isBmpFile(imageData)) {
            return false;
        }
        return ImageTransformer.getBmpFileBitCount(imageData) == 1;
    }

    private static int getBmpFileBitCount(byte[] imageData) {
        if (imageData == null || imageData.length < 54) {
            return 0;
        }
        int offset = 28;
        return ImageTransformer.getShort(imageData, offset);
    }

    private static int getShort(byte[] bytes, int offset) {
        return (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    public static ByteArrayOutputStream convert1BitBmp(byte[] imageData) {
        if (imageData == null) {
            throw new NullPointerException("imageData is null!");
        }
        if (ImageTransformer.isMonoBmpFile(imageData)) {
            logger.debug("/// convert1BitBmp | It is a mono bitmap file!", new Object[0]);
            return ImageTransformer.toByteArrayOutputStream(imageData);
        }
        byte[] bmpData = ImageTransformer.transformToBmpFile(imageData);
        if (bmpData == null) {
            logger.error("/// convert1BitBmp | transform to bmp file failed!", new Object[0]);
            return null;
        }
        BytesBuffer outBmp = new BytesBuffer();
        int iRet = BmpUtil.binarizeBmpFile(bmpData, outBmp);
        if (iRet != 0) {
            logger.error("/// convert1BitBmp | binarize bmp file failed!", new Object[0]);
            return null;
        }
        return ImageTransformer.toByteArrayOutputStream(outBmp.getData());
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        baos.write(data, 0, data.length);
        return baos;
    }

    public static byte[] transformToBmpFile(byte[] imageData) {
        if (imageData == null) {
            return null;
        }
        if (ImageTransformer.isBmpFile(imageData)) {
            return imageData;
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
        if (bitmap == null) {
            logger.error("/// transformToBmpFile | Image data could not be decoded!!!", new Object[0]);
            return null;
        }
        int nBmpWidth = bitmap.getWidth();
        int nBmpHeight = bitmap.getHeight();
        int[] pixels = new int[nBmpWidth * nBmpHeight];
        bitmap.getPixels(pixels, 0, nBmpWidth, 0, 0, nBmpWidth, nBmpHeight);
        BytesBuffer rgbData = new BytesBuffer();
        BmpUtil.convertPixel2RGB(pixels, nBmpWidth, nBmpHeight, rgbData);
        byte[] rgb = rgbData.getData();
        int rgbSize = rgb.length;
        byte[] fileHeader = ImageTransformer.createBmpImageHeader(rgbSize);
        byte[] infoHeader = ImageTransformer.createBmpImageInfosHeader(nBmpWidth, nBmpHeight);
        byte[] bmpFile = new byte[54 + rgbSize];
        System.arraycopy(fileHeader, 0, bmpFile, 0, fileHeader.length);
        System.arraycopy(infoHeader, 0, bmpFile, 14, infoHeader.length);
        System.arraycopy(rgb, 0, bmpFile, 54, rgbSize);
        return bmpFile;
    }

    private static byte[] createBmpImageHeader(int rgbLength) {
        byte[] fileHeader = new byte[14];
        int size = 54 + rgbLength;
        int offset = 0;
        fileHeader[offset++] = 66;
        fileHeader[offset++] = 77;
        fileHeader[offset++] = (byte)(size >> 0);
        fileHeader[offset++] = (byte)(size >> 8);
        fileHeader[offset++] = (byte)(size >> 16);
        fileHeader[offset++] = (byte)(size >> 24);
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 54;
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 0;
        fileHeader[offset++] = 0;
        return fileHeader;
    }

    private static byte[] createBmpImageInfosHeader(int width, int height) {
        byte[] infoHeader = new byte[40];
        int offset = 0;
        infoHeader[offset++] = 40;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = (byte)(width >> 0);
        infoHeader[offset++] = (byte)(width >> 8);
        infoHeader[offset++] = (byte)(width >> 16);
        infoHeader[offset++] = (byte)(width >> 24);
        infoHeader[offset++] = (byte)(height >> 0);
        infoHeader[offset++] = (byte)(height >> 8);
        infoHeader[offset++] = (byte)(height >> 16);
        infoHeader[offset++] = (byte)(height >> 24);
        infoHeader[offset++] = 1;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 32;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = -32;
        infoHeader[offset++] = 1;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 2;
        infoHeader[offset++] = 3;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        infoHeader[offset++] = 0;
        return infoHeader;
    }

    private static byte[] createBmpRGB(int[] pixels, int width, int height) {
        int len = pixels.length;
        byte[] buffer = new byte[width * height * 4];
        int offset = 0;
        for (int row = height - 1; row >= 0; --row) {
            for (int col = 0; col < width; ++col) {
                int index = row * width + col;
                int pixel = pixels[index];
                buffer[offset++] = (byte)(pixels[index] >> 0);
                buffer[offset++] = (byte)(pixels[index] >> 8);
                buffer[offset++] = (byte)(pixels[index] >> 16);
                buffer[offset++] = (byte)Color.alpha((int)255);
            }
        }
        return buffer;
    }

    public static ByteArrayOutputStream convert1BitBmp(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException();
        }
        int nBmpWidth = bitmap.getWidth();
        int nBmpHeight = bitmap.getHeight();
        int wid = nBmpWidth % 32;
        if (wid > 0) {
            wid = 32 - nBmpWidth % 32;
        }
        int bufferSize = nBmpHeight * (wid += nBmpWidth) / 8;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int bfType = 19778;
            long bfSize = 62 + bufferSize;
            int bfReserved1 = 0;
            int bfReserved2 = 0;
            long bfOffBits = 62L;
            ImageTransformer.writeWord(os, bfType);
            ImageTransformer.writeDword(os, bfSize);
            ImageTransformer.writeWord(os, bfReserved1);
            ImageTransformer.writeWord(os, bfReserved2);
            ImageTransformer.writeDword(os, bfOffBits);
            long biSize = 40L;
            long biWidth = nBmpWidth;
            long biHeight = nBmpHeight;
            int biPlanes = 1;
            int biBitCount = 1;
            long biCompression = 0L;
            long biSizeImage = bufferSize;
            long biXpelsPerMeter = 0L;
            long biYPelsPerMeter = 0L;
            long biClrUsed = 0L;
            long biClrImportant = 2L;
            ImageTransformer.writeDword(os, biSize);
            ImageTransformer.writeLong(os, biWidth);
            ImageTransformer.writeLong(os, biHeight);
            ImageTransformer.writeWord(os, biPlanes);
            ImageTransformer.writeWord(os, biBitCount);
            ImageTransformer.writeDword(os, biCompression);
            ImageTransformer.writeDword(os, biSizeImage);
            ImageTransformer.writeLong(os, biXpelsPerMeter);
            ImageTransformer.writeLong(os, biYPelsPerMeter);
            ImageTransformer.writeDword(os, biClrUsed);
            ImageTransformer.writeDword(os, biClrImportant);
            int rgbBlue0 = -1;
            int rgbGreen0 = -1;
            int rgbRed0 = -1;
            int rgbReserved0 = 0;
            int rgbBlue1 = 0;
            int rgbGreen1 = 0;
            int rgbRed1 = 0;
            int rgbReserved1 = 0;
            ImageTransformer.writeByte(os, rgbBlue0);
            ImageTransformer.writeByte(os, rgbGreen0);
            ImageTransformer.writeByte(os, rgbRed0);
            ImageTransformer.writeByte(os, rgbReserved0);
            ImageTransformer.writeByte(os, rgbBlue1);
            ImageTransformer.writeByte(os, rgbGreen1);
            ImageTransformer.writeByte(os, rgbRed1);
            ImageTransformer.writeByte(os, rgbReserved1);
            int[][] pixels = new int[nBmpWidth][nBmpHeight];
            int threshold = ImageTransformer.getThreshold(bitmap, nBmpWidth, nBmpHeight, pixels);
            byte[] bmpData = new byte[bufferSize];
            for (int r = 0; r < nBmpHeight; ++r) {
                int c = 0;
                while (c < nBmpWidth) {
                    int color0 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color1 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color2 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color3 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color4 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color5 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color6 = ImageTransformer.getPixel(pixels, c++, r, threshold, nBmpWidth, nBmpHeight);
                    int color7 = ImageTransformer.getPixel(pixels, c, r, threshold, nBmpWidth, nBmpHeight);
                    bmpData[(nBmpHeight - r - 1) * (wid / 8) + c++ / 8] = (byte)(color0 << 7 | color1 << 6 | color2 << 5 | color3 << 4 | color4 << 3 | color5 << 2 | color6 << 1 | color7);
                }
            }
            os.write(bmpData);
            os.flush();
            return os;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getPixel(int[][] pixels, int x, int y, int thresholde, int width, int height) {
        if (x < width && y < height) {
            int clr = pixels[x][y];
            int gray = Color.red((int)clr) * 38 + Color.green((int)clr) * 75 + Color.blue((int)clr) * 15 >> 7;
            return gray > thresholde ? 0 : 1;
        }
        return 1;
    }

    private static int getThreshold(Bitmap bmp, int bmpWidth, int bmpHeight, int[][] pixels) {
        double[] histGram = new double[256];
        for (int i = 0; i != 256; ++i) {
            histGram[i] = 0.0;
        }
        for (int c = 0; c < bmpHeight; ++c) {
            for (int wRow = 0; wRow < bmpWidth; ++wRow) {
                int gray;
                int clr = bmp.getPixel(wRow, c);
                int red = Color.red((int)clr);
                int blue = Color.blue((int)clr);
                int green = Color.green((int)clr);
                int n = gray = Color.red((int)clr) * 38 + Color.green((int)clr) * 75 + Color.blue((int)clr) * 15 >> 7;
                histGram[n] = histGram[n] + 1.0;
                pixels[wRow][c] = clr;
            }
        }
        int k = 0;
        double m1 = 0.0;
        double m2 = 0.0;
        double sum = 0.0;
        double csum = 0.0;
        double fmax = 0.0;
        double sb = 0.0;
        int threshValue = 1;
        csum = 0.0;
        sum = 0.0;
        int n = 0;
        int n1 = 0;
        int n2 = 0;
        for (k = 0; k <= 255; ++k) {
            sum += (double)k * histGram[k];
            n = (int)((double)n + histGram[k]);
        }
        fmax = -1.0;
        n1 = 0;
        for (k = 0; k < 255; ++k) {
            if ((n1 = (int)((double)n1 + histGram[k])) == 0) continue;
            n2 = n - n1;
            if (n2 == 0) break;
            m1 = (csum += (double)k * histGram[k]) / (double)n1;
            if (!((sb = (double)n1 * (double)n2 * (m1 - (m2 = (sum - csum) / (double)n2)) * (m1 - m2)) > fmax)) continue;
            fmax = sb;
            threshValue = k;
        }
        return threshValue;
    }

    private static void writeByte(OutputStream stream, int value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFF)};
        stream.write(b);
    }

    private static void writeWord(OutputStream stream, int value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        stream.write(b);
    }

    private static void writeDword(OutputStream stream, long value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        stream.write(b);
    }

    private static void writeLong(OutputStream stream, long value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        stream.write(b);
    }
}

